/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.trie;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public final class TopicTrieNode<V> {
    private final String levelName;
    private final boolean wildcardMatchable;
    private final NavigableMap<String, TopicTrieNode<V>> children = new TreeMap<String, TopicTrieNode<V>>();
    private final Set<V> values = new HashSet<V>();
    private List<String> topic;

    public static <V> Builder<V> builder(boolean isGlobal) {
        return new Builder(isGlobal);
    }

    private TopicTrieNode() {
        this("\u0000", false);
    }

    private TopicTrieNode(String levelName, boolean wildcardMatchable) {
        this.levelName = levelName;
        this.wildcardMatchable = wildcardMatchable;
    }

    String levelName() {
        return this.levelName;
    }

    boolean isUserTopic() {
        return !this.values.isEmpty();
    }

    List<String> topic() {
        return this.topic;
    }

    Set<V> values() {
        return Collections.unmodifiableSet(this.values);
    }

    boolean wildcardMatchable() {
        return this.wildcardMatchable;
    }

    NavigableMap<String, TopicTrieNode<V>> children() {
        return Collections.unmodifiableNavigableMap(this.children);
    }

    TopicTrieNode<V> child(String levelName) {
        return (TopicTrieNode)this.children.get(levelName);
    }

    public static class Builder<V> {
        private final TopicTrieNode<V> root = new TopicTrieNode();
        private final boolean isGlobal;

        private Builder(boolean isGlobal) {
            this.isGlobal = isGlobal;
        }

        public TopicTrieNode<V> build() {
            return this.root;
        }

        public Builder<V> addTopic(List<String> topicLevels, V value) {
            assert (!this.isGlobal ? !topicLevels.isEmpty() : topicLevels.size() > 1);
            this.addChild(this.root, 0, topicLevels, value);
            return this;
        }

        private void addChild(TopicTrieNode<V> node, int level, List<String> topicLevels, V value) {
            if (topicLevels.isEmpty()) {
                return;
            }
            String levelName = topicLevels.get(level);
            boolean wildcardMatchable = this.isGlobal ? level > 1 || level == 1 && !levelName.startsWith("$") : level > 0 || !levelName.startsWith("$");
            TopicTrieNode child = node.children.computeIfAbsent(levelName, k -> new TopicTrieNode(levelName, wildcardMatchable));
            if (level == topicLevels.size() - 1) {
                child.topic = topicLevels;
                child.values.add(value);
            } else {
                this.addChild(child, level + 1, topicLevels, value);
            }
        }
    }
}

