/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.QuorumTracker;
import org.apache.bifromq.basekv.raft.exception.ReadIndexException;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.slf4j.Logger;

class ReadProgressTracker {
    private final TreeMap<Long, ReadProgress> readProgressMap = new TreeMap();
    private final IRaftStateStore stateStorage;
    private final Logger logger;
    private int total;

    ReadProgressTracker(IRaftStateStore stateStorage, Logger logger) {
        this.stateStorage = stateStorage;
        this.logger = logger;
    }

    public void add(Long readIndex, CompletableFuture<Long> onDone) {
        this.readProgressMap.compute(readIndex, (key, value) -> {
            if (value == null) {
                value = new ReadProgress(this.stateStorage.latestClusterConfig(), this.logger);
                value.confirmTracker.poll(this.stateStorage.local(), true);
            }
            value.add(onDone);
            ++this.total;
            return value;
        });
    }

    public void confirm(long readIndex, String fromPeer) {
        ReadProgress readProgress = this.readProgressMap.get(readIndex);
        if (readProgress != null) {
            readProgress.confirmTracker.poll(fromPeer, true);
            QuorumTracker.JointVoteResult commitTallyResult = readProgress.confirmTracker.tally();
            if (commitTallyResult.result == QuorumTracker.VoteResult.Won) {
                while (!this.readProgressMap.isEmpty()) {
                    Map.Entry<Long, ReadProgress> entry = this.readProgressMap.pollFirstEntry();
                    entry.getValue().complete(readIndex);
                    this.total -= entry.getValue().count();
                    if (readIndex != entry.getKey()) continue;
                    break;
                }
            }
        }
    }

    public void abort(ReadIndexException e) {
        this.logger.debug("Abort on-going read progresses");
        this.readProgressMap.values().forEach(p -> p.abort(e));
        this.readProgressMap.clear();
        this.total = 0;
    }

    public long highestReadIndex() {
        if (!this.readProgressMap.isEmpty()) {
            return this.readProgressMap.lastKey();
        }
        return 0L;
    }

    public int underConfirming() {
        return this.total;
    }

    private static class ReadProgress {
        private final List<CompletableFuture<Long>> pendingFutures = new ArrayList<CompletableFuture<Long>>();
        private final QuorumTracker confirmTracker;

        ReadProgress(ClusterConfig clusterConfig, Logger logger) {
            this.confirmTracker = new QuorumTracker(clusterConfig, logger);
        }

        void add(CompletableFuture<Long> future) {
            this.pendingFutures.add(future);
        }

        void complete(Long readIndex) {
            this.pendingFutures.forEach(future -> future.complete(readIndex));
        }

        void abort(ReadIndexException e) {
            this.pendingFutures.forEach(future -> future.completeExceptionally(e));
        }

        int count() {
            return this.pendingFutures.size();
        }
    }
}

