/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Struct;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.IMVReg;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.metaservice.CRDTUtil;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposalCRDT;
import org.apache.bifromq.basekv.proto.BalancerStateSnapshot;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVStoreBalancerStatesProposalCRDT
implements IBaseKVStoreBalancerStatesProposalCRDT {
    private final String clusterId;
    private final Logger log;
    private final ICRDTService crdtService;
    private final IORMap expectedBalancerStatesORMap;
    private final BehaviorSubject<Map<String, BalancerStateSnapshot>> expectedBalancerStatesSubject = BehaviorSubject.createDefault(Collections.emptyMap());
    private final CompositeDisposable disposable = new CompositeDisposable();

    BaseKVStoreBalancerStatesProposalCRDT(String clusterId, ICRDTService crdtService) {
        this.clusterId = clusterId;
        this.log = MDCLogger.getLogger(BaseKVStoreBalancerStatesProposalCRDT.class, (String[])new String[]{"clusterId", clusterId});
        this.crdtService = crdtService;
        this.expectedBalancerStatesORMap = (IORMap)crdtService.host(CRDTUtil.toBalancerStateProposalURI(clusterId));
        this.disposable.add(this.expectedBalancerStatesORMap.inflation().observeOn(IBaseKVMetaService.SHARED_SCHEDULER).map(this::buildExpectedBalancerStateSnapshots).subscribe(arg_0 -> this.expectedBalancerStatesSubject.onNext(arg_0)));
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public Observable<Map<String, BalancerStateSnapshot>> expectedBalancerStates() {
        return this.expectedBalancerStatesSubject.distinctUntilChanged();
    }

    @Override
    public Optional<BalancerStateSnapshot> expectedBalancerState(String balancerFactoryClassFQN) {
        Map snapshotMap = (Map)this.expectedBalancerStatesSubject.getValue();
        if (snapshotMap == null || snapshotMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((BalancerStateSnapshot)snapshotMap.get(balancerFactoryClassFQN));
    }

    @Override
    public CompletableFuture<Void> setBalancerState(String balancerFactoryClassFQN, boolean disable, Struct loadRules) {
        BalancerStateSnapshot existing;
        Map snapshotMap = (Map)this.expectedBalancerStatesSubject.getValue();
        if (snapshotMap.containsKey(balancerFactoryClassFQN) && (existing = snapshotMap.getOrDefault(balancerFactoryClassFQN, BalancerStateSnapshot.getDefaultInstance())).getDisable() == disable && existing.getLoadRules().equals((Object)loadRules)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.expectedBalancerStatesORMap.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{ByteString.copyFromUtf8((String)balancerFactoryClassFQN)}).with(MVRegOperation.write((ByteString)BalancerStateSnapshot.newBuilder().setDisable(disable).setLoadRules(loadRules).setHlc(HLC.INST.get()).build().toByteString())));
    }

    @Override
    public CompletableFuture<Void> removeBalancerState(String balancerFactoryClassFQN) {
        return this.expectedBalancerStatesORMap.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{ByteString.copyFromUtf8((String)balancerFactoryClassFQN)}).of(CausalCRDTType.mvreg));
    }

    @Override
    public void stop() {
        this.disposable.dispose();
        this.crdtService.stopHosting(this.expectedBalancerStatesORMap.id().getUri()).join();
    }

    private Map<String, BalancerStateSnapshot> buildExpectedBalancerStateSnapshots(long ts) {
        HashMap<String, BalancerStateSnapshot> balancerStatesMap = new HashMap<String, BalancerStateSnapshot>();
        this.expectedBalancerStatesORMap.keys().forEachRemaining(ormapKey -> {
            String balancerClassFQN = ormapKey.key().toStringUtf8();
            Optional<BalancerStateSnapshot> balancerStateOpt = this.buildBalancerStateSnapshot(this.expectedBalancerStatesORMap.getMVReg(new ByteString[]{ormapKey.key()}));
            balancerStateOpt.ifPresent(stateSnapshot -> balancerStatesMap.put(balancerClassFQN, (BalancerStateSnapshot)stateSnapshot));
        });
        this.log.debug("Expected balancer states changed: {}", balancerStatesMap);
        return balancerStatesMap;
    }

    private Optional<BalancerStateSnapshot> buildBalancerStateSnapshot(IMVReg mvReg) {
        ArrayList l = Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.transform((Iterator)mvReg.read(), b -> {
            try {
                return BalancerStateSnapshot.parseFrom(b);
            }
            catch (InvalidProtocolBufferException e) {
                this.log.error("Unable to parse BalancerState", (Throwable)e);
                return null;
            }
        }), Objects::nonNull));
        l.sort((a, b) -> Long.compareUnsigned(b.getHlc(), a.getHlc()));
        return Optional.ofNullable(l.isEmpty() ? null : (BalancerStateSnapshot)l.get(0));
    }
}

