/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.AbstractLandscapeHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.apiserver.http.handler.utils.JSONUtils;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeObserver;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficGovernor;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.apache.bifromq.baserpc.trafficgovernor.ServerEndpoint;

@Path(value="/store/landscape")
class GetStoreLandscapeHandler
extends AbstractLandscapeHandler {
    private static final String STORE_SERVICE_NAME_SUFFIX = "@basekv.BaseKVStoreService";
    protected final Map<String, IRPCServiceTrafficGovernor> governorMap = new ConcurrentHashMap<String, IRPCServiceTrafficGovernor>();
    private final IRPCServiceTrafficService trafficService;
    private final CompositeDisposable disposable = new CompositeDisposable();

    GetStoreLandscapeHandler(IBaseKVMetaService metaService, IRPCServiceTrafficService trafficService) {
        super(metaService);
        this.trafficService = trafficService;
    }

    public static JsonNode toJSON(Map<ServerEndpoint, KVRangeStoreDescriptor> landscape) {
        ArrayNode rootObject = JSONUtils.MAPPER.createArrayNode();
        for (ServerEndpoint server : landscape.keySet()) {
            KVRangeStoreDescriptor storeDescriptor = landscape.get(server);
            ObjectNode storeNodeObject = JSONUtils.MAPPER.createObjectNode();
            storeNodeObject.put("hostId", Base64.getEncoder().encodeToString(server.hostId().toByteArray()));
            storeNodeObject.put("id", storeDescriptor.getId());
            storeNodeObject.put("address", server.address());
            storeNodeObject.put("port", server.port());
            ObjectNode attrsObject = JSONUtils.MAPPER.createObjectNode();
            for (String attrName : storeDescriptor.getAttributesMap().keySet()) {
                attrsObject.put(attrName, (String)storeDescriptor.getAttributesMap().get(attrName));
            }
            storeNodeObject.set("attributes", (JsonNode)attrsObject);
            rootObject.add((JsonNode)storeNodeObject);
        }
        return rootObject;
    }

    @Override
    public void start() {
        super.start();
        this.disposable.add(this.trafficService.services().subscribe(serviceUniqueNames -> {
            this.governorMap.keySet().removeIf(serviceUniqueName -> !serviceUniqueNames.contains(serviceUniqueName));
            for (String serviceUniqueName2 : serviceUniqueNames) {
                if (!serviceUniqueName2.endsWith(STORE_SERVICE_NAME_SUFFIX)) continue;
                this.governorMap.computeIfAbsent(serviceUniqueName2, arg_0 -> ((IRPCServiceTrafficService)this.trafficService).getTrafficGovernor(arg_0));
            }
        }));
    }

    @Override
    public void close() {
        super.close();
        this.disposable.dispose();
    }

    @Override
    @GET
    @Operation(summary="Get the store landscape information")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="store_name", in=ParameterIn.HEADER, required=true, description="the store name", schema=@Schema(implementation=String.class))})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Store not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) FullHttpRequest req) {
        String storeName = HeaderUtils.getHeader(Headers.HEADER_STORE_NAME, (HttpRequest)req, true);
        IBaseKVLandscapeObserver landscapeObserver = (IBaseKVLandscapeObserver)this.landscapeObservers.get(storeName);
        IRPCServiceTrafficGovernor trafficGovernor = this.governorMap.get(storeName + STORE_SERVICE_NAME_SUFFIX);
        if (landscapeObserver == null || trafficGovernor == null) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])("Service not found: " + storeName).getBytes())));
        }
        return Observable.combineLatest((ObservableSource)landscapeObserver.landscape(), (ObservableSource)trafficGovernor.serverEndpoints(), (stores, serverEndpoints) -> {
            HashMap<ServerEndpoint, KVRangeStoreDescriptor> storeToServer = new HashMap<ServerEndpoint, KVRangeStoreDescriptor>();
            for (ServerEndpoint serverEndpoint : serverEndpoints) {
                String storeId = (String)serverEndpoint.attrs().get("store_id");
                if (storeId == null || !stores.containsKey(storeId)) continue;
                storeToServer.put(serverEndpoint, (KVRangeStoreDescriptor)stores.get(storeId));
            }
            return storeToServer;
        }).firstElement().toCompletionStage().toCompletableFuture().thenApply(serverToStore -> {
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])GetStoreLandscapeHandler.toJSON(serverToStore).toString().getBytes()));
            resp.headers().set("Content-Type", (Object)"application/json");
            return resp;
        });
    }
}

