/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.JsonReader;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.Strings;

public interface PropertySource {
    public static final String PREFIX = "log4j2.";
    public static final String SYSTEM_CONTEXT = "*";
    public static final int DEFAULT_PRIORITY = 200;
    public static final String MAPPING_FILE = "log4j2.propertyMapping.json";

    default public int getPriority() {
        return 200;
    }

    default public void forEach(BiConsumer<String, String> action) {
    }

    default public Collection<String> getPropertyNames() {
        return Collections.emptySet();
    }

    default public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return Util.join(tokens);
    }

    default public String getProperty(String key) {
        return null;
    }

    default public boolean containsProperty(String key) {
        return false;
    }

    public static final class Util {
        private static final Map<String, List<CharSequence>> CACHE = new ConcurrentHashMap<String, List<CharSequence>>();

        public static List<CharSequence> tokenize(CharSequence value) {
            String key = value.toString();
            if (CACHE.containsKey(key)) {
                return CACHE.get(key);
            }
            List<CharSequence> tokens = List.of(key.split("[._/]+"));
            CACHE.put(key, tokens);
            return tokens;
        }

        public static CharSequence join(Iterable<? extends CharSequence> tokens) {
            StringBuilder sb = new StringBuilder();
            int tokenCount = 0;
            Collection tokenCollection = (Collection)Cast.cast(tokens);
            int lowerIndex = tokenCollection.size() > 3 ? 3 : 1;
            for (CharSequence charSequence : tokens) {
                if (sb.length() > 0) {
                    sb.append(".");
                    if (tokenCount >= lowerIndex) {
                        sb.append(Character.toLowerCase(charSequence.charAt(0)));
                        sb.append(charSequence.subSequence(1, charSequence.length()));
                    } else {
                        sb.append(charSequence);
                    }
                } else {
                    sb.append(charSequence);
                }
                ++tokenCount;
            }
            return sb.toString();
        }

        public static CharSequence joinAsCamelCase(Iterable<? extends CharSequence> tokens) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (CharSequence charSequence : tokens) {
                if (first) {
                    sb.append(charSequence);
                } else {
                    sb.append(Character.toUpperCase(charSequence.charAt(0)));
                    if (charSequence.length() > 1) {
                        sb.append(charSequence.subSequence(1, charSequence.length()));
                    }
                }
                first = false;
            }
            return sb.toString();
        }

        static String resolveKey(String key) {
            List<CharSequence> tokens = Util.getTokens(key);
            return tokens != null ? Util.join(tokens).toString() : key;
        }

        static List<CharSequence> getTokens(String key) {
            List<CharSequence> tokens = CACHE.get(key);
            if (tokens == null) {
                tokens = Util.tokenize(key);
            }
            return tokens;
        }

        static void populateCache() {
            try {
                Enumeration<URL> urls = PropertySource.class.getClassLoader().getResources(PropertySource.MAPPING_FILE);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        InputStream is = url.openStream();
                        try {
                            String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                            Map root = (Map)Cast.cast(JsonReader.read(json));
                            Util.populateCache("", root);
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    catch (Exception ex) {
                        LowLevelLogUtil.logException("Unable to parse JSON for " + url.toString(), ex);
                    }
                }
            }
            catch (Exception ex) {
                LowLevelLogUtil.logException("Unable to access log4j2.propertyMapping.json", ex);
            }
        }

        static void populateCache(String prefix, Map<String, Object> root) {
            if (!root.isEmpty()) {
                for (Map.Entry<String, Object> entry : root.entrySet()) {
                    String delim;
                    String string = delim = entry.getKey().equals(entry.getKey().toUpperCase(Locale.ROOT)) ? "_" : ".";
                    if (entry.getValue() instanceof String) {
                        String value = (String)Cast.cast(entry.getValue());
                        CACHE.put(prefix + delim + entry.getKey(), Collections.singletonList(value));
                        continue;
                    }
                    if (entry.getValue() instanceof List) {
                        CACHE.put(prefix + delim + entry.getKey(), (List)Cast.cast(entry.getValue()));
                        continue;
                    }
                    String key = Strings.isEmpty(prefix) ? entry.getKey() : prefix + delim + entry.getKey();
                    Util.populateCache(key, (Map)Cast.cast(entry.getValue()));
                }
            }
        }

        private Util() {
        }

        static {
            Util.populateCache();
        }
    }

    public static class Comparator
    implements java.util.Comparator<PropertySource> {
        @Override
        public int compare(PropertySource o1, PropertySource o2) {
            int result = Integer.compare(Objects.requireNonNull(o1).getPriority(), Objects.requireNonNull(o2).getPriority());
            if (result == 0) {
                result = o1.equals(o2) ? 0 : -1;
            }
            return result;
        }
    }
}

