/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.data.type.DataType;

public class FloatListDataType
implements DataType<List<Float>> {
    @Override
    public int size(List<Float> values) {
        return 4 + values.size() * 4;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Float> values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (float value : values) {
            buffer.putFloat(p, value);
            p += 4;
        }
    }

    @Override
    public List<Float> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 4;
        ArrayList<Float> values = new ArrayList<Float>(length);
        for (int index = 0; index < length; ++index) {
            values.add(Float.valueOf(buffer.getFloat(position + 4 + index * 4)));
        }
        return values;
    }
}

