/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.awt.geom.AffineTransform;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Resources;
import org.apache.sis.storage.sql.postgis.Band;
import org.apache.sis.storage.sql.postgis.RasterFormat;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class RasterWriter
extends RasterFormat {
    private ByteOrder byteOrder = ByteOrder.nativeOrder();
    private AffineTransform gridToCRS;
    private int srid;
    private Number[] noDataValues;

    public RasterWriter(InfoStatements spatialRefSys) {
        super(spatialRefSys);
    }

    public void reset() {
        this.byteOrder = ByteOrder.nativeOrder();
        this.gridToCRS = null;
        this.srid = 0;
    }

    public void setGridToCRS(GridGeometry gg) throws Exception {
        if (gg.isDefined(1)) {
            CoordinateReferenceSystem crs = gg.getCoordinateReferenceSystem();
            if (this.spatialRefSys != null) {
                this.srid = this.spatialRefSys.findSRID(crs);
            } else {
                Integer epsg = IdentifiedObjects.lookupEPSG((IdentifiedObject)crs);
                if (epsg == null) {
                    throw new IllegalArgumentException(Resources.format((short)15, IdentifiedObjects.getDisplayName((IdentifiedObject)crs, null)));
                }
                this.srid = epsg;
            }
        } else {
            this.srid = 0;
        }
        this.gridToCRS = AffineTransforms2D.castOrCopy(gg.isDefined(8) ? gg.getGridToCRS(ANCHOR) : null);
    }

    public void setNodataValues(List<? extends SampleDimension> bands) {
        this.noDataValues = new Number[bands.size()];
        for (int b = 0; b < this.noDataValues.length; ++b) {
            SampleDimension sd = bands.get(b);
            this.noDataValues[b] = sd.getBackground().orElse(null);
        }
    }

    public void write(GridCoverage coverage, ChannelDataOutput output) throws Exception {
        this.setGridToCRS(coverage.getGridGeometry());
        this.setNodataValues(coverage.getSampleDimensions());
        this.write(coverage.render(null), output);
    }

    public void write(RenderedImage image, ChannelDataOutput output) throws IOException {
        Raster raster = image.getNumXTiles() == 1 && image.getNumYTiles() == 1 ? image.getTile(image.getMinTileX(), image.getMinTileY()) : image.getData();
        this.write(raster, output);
    }

    public void write(Raster raster, ChannelDataOutput output) throws IOException {
        if (this.gridToCRS == null) {
            this.gridToCRS = new AffineTransform();
        }
        SampleModel sm = raster.getSampleModel();
        int numBands = sm.getNumBands();
        int width = raster.getWidth();
        int height = raster.getHeight();
        boolean direct = false;
        int dataType = sm.getDataType();
        int pixelType = Band.bufferToPixelType(dataType);
        if (sm instanceof SinglePixelPackedSampleModel) {
            if (numBands == 1) {
                direct = ((SinglePixelPackedSampleModel)sm).getScanlineStride() == width;
            } else {
                int sampleSize = Arrays.stream(sm.getSampleSize()).max().orElse(0);
                if (sampleSize >= 1 && sampleSize <= 16) {
                    dataType = sampleSize <= 8 ? 0 : 1;
                    pixelType = Band.bufferToPixelType(dataType);
                }
            }
        } else if (sm instanceof MultiPixelPackedSampleModel) {
            if (dataType == 0) {
                MultiPixelPackedSampleModel mp = (MultiPixelPackedSampleModel)sm;
                int sampleSize = mp.getPixelBitStride();
                direct = mp.getScanlineStride() * 8 == width * sampleSize;
                pixelType = Band.sizeToPixelType(sampleSize);
            }
        } else if (sm instanceof ComponentSampleModel) {
            direct = ((ComponentSampleModel)sm).getScanlineStride() == width;
        }
        output.buffer.order(this.byteOrder);
        output.writeByte(ByteOrder.LITTLE_ENDIAN.equals(this.byteOrder) ? 1 : 0);
        output.writeShort(0);
        output.writeShort(RasterWriter.ensureUnsignedShort("numBands", numBands));
        output.writeDouble(this.gridToCRS.getScaleX());
        output.writeDouble(this.gridToCRS.getScaleY());
        output.writeDouble(this.gridToCRS.getTranslateX());
        output.writeDouble(this.gridToCRS.getTranslateY());
        output.writeDouble(this.gridToCRS.getShearX());
        output.writeDouble(this.gridToCRS.getShearY());
        output.writeInt(this.srid);
        output.writeShort(RasterWriter.ensureUnsignedShort("width", width));
        output.writeShort(RasterWriter.ensureUnsignedShort("height", height));
        for (int b = 0; b < numBands; ++b) {
            Number fill = this.noDataValues != null && b < this.noDataValues.length ? (Number)this.noDataValues[b] : (Number)null;
            Band band = new Band(pixelType, fill);
            output.writeByte(band.header);
            switch (dataType) {
                case 1: 
                case 2: {
                    output.writeShort(fill != null ? fill.intValue() : 0);
                    break;
                }
                case 0: {
                    output.writeByte(fill != null ? fill.intValue() : 0);
                    break;
                }
                case 3: {
                    output.writeInt(fill != null ? fill.intValue() : 0);
                    break;
                }
                case 4: {
                    output.writeFloat(fill != null ? fill.floatValue() : Float.NaN);
                    break;
                }
                case 5: {
                    output.writeDouble(fill != null ? fill.doubleValue() : Double.NaN);
                    break;
                }
                default: {
                    throw new RasterFormatException(Errors.format((short)163, (Object)dataType));
                }
            }
            if (direct) {
                DataBuffer buffer = raster.getDataBuffer();
                int offset = buffer.getOffsets()[b];
                int length = width * height;
                switch (dataType) {
                    case 0: {
                        output.write(((DataBufferByte)buffer).getData(b), offset, length);
                        break;
                    }
                    case 1: {
                        output.writeShorts(((DataBufferUShort)buffer).getData(b), offset, length);
                        break;
                    }
                    case 2: {
                        output.writeShorts(((DataBufferShort)buffer).getData(b), offset, length);
                        break;
                    }
                    case 3: {
                        output.writeInts(((DataBufferInt)buffer).getData(b), offset, length);
                        break;
                    }
                    case 4: {
                        output.writeFloats(((DataBufferFloat)buffer).getData(b), offset, length);
                        break;
                    }
                    case 5: {
                        output.writeDoubles(((DataBufferDouble)buffer).getData(b), offset, length);
                    }
                }
                continue;
            }
            PixelIterator it = new PixelIterator.Builder().create(raster);
            while (it.next()) {
                switch (dataType) {
                    case 1: 
                    case 2: {
                        output.writeShort(it.getSample(b));
                        break;
                    }
                    case 0: {
                        output.writeByte(it.getSample(b));
                        break;
                    }
                    case 3: {
                        output.writeInt(it.getSample(b));
                        break;
                    }
                    case 4: {
                        output.writeFloat((float)it.getSample(b));
                        break;
                    }
                    case 5: {
                        output.writeDouble((double)it.getSample(b));
                    }
                }
            }
        }
    }

    private static int ensureUnsignedShort(String name, int value) {
        if ((value & 0xFFFF0000) == 0) {
            return value;
        }
        throw new RasterFormatException(Errors.format((short)166, (Object)name, (Object)1, (Object)65535, (Object)value));
    }
}

