/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedImageResource {
    private static final Logger logger = LoggerFactory.getLogger(BufferedImageResource.class);
    public static final String TILE_TYPE = "image/png";
    private final Supplier<TileStore<BufferedImage>> tileStoreSupplier;

    public BufferedImageResource(Supplier<TileStore<BufferedImage>> tileStoreSupplier) {
        this.tileStoreSupplier = tileStoreSupplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Get(value="regex:^/(?<z>[0-9]+)/(?<x>[0-9]+)/(?<y>[0-9]+).png")
    @Blocking
    public HttpResponse tile(@Param(value="z") int z, @Param(value="x") int x, @Param(value="y") int y) {
        TileCoord tileCoord = new TileCoord(x, y, z);
        TileStore<BufferedImage> tileStore = this.tileStoreSupplier.get();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            BufferedImage bufferedImage = (BufferedImage)tileStore.read(tileCoord);
            if (bufferedImage != null) {
                ResponseHeaders headers = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", TILE_TYPE).add((CharSequence)"Access-Control-Allow-Origin", "*").build();
                ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                HttpData data = HttpData.wrap((byte[])outputStream.toByteArray());
                HttpResponse httpResponse = HttpResponse.of((ResponseHeaders)headers, (HttpData)data);
                return httpResponse;
            }
            HttpResponse httpResponse = HttpResponse.of((int)204);
            return httpResponse;
        }
        catch (Exception ex) {
            logger.error("Error while reading tile.", (Throwable)ex);
            return HttpResponse.of((int)404);
        }
    }
}

