/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.io.BaseEncoding;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import java.util.Objects;
import java.util.function.BiFunction;

final class DefaultEntityTagFunction
implements BiFunction<String, HttpFileAttributes, String> {
    private static final BaseEncoding etagEncoding = BaseEncoding.base64().omitPadding();
    private static final DefaultEntityTagFunction INSTANCE = new DefaultEntityTagFunction();

    static DefaultEntityTagFunction get() {
        return INSTANCE;
    }

    private DefaultEntityTagFunction() {
    }

    @Override
    public String apply(String pathOrUri, HttpFileAttributes attrs) {
        Objects.requireNonNull(pathOrUri, "pathOrUri");
        Objects.requireNonNull(attrs, "attrs");
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            byte[] data = tempThreadLocals.byteArray(20);
            long hashCode = (long)pathOrUri.hashCode() & 0xFFFFFFFFL;
            long length = attrs.length();
            long lastModifiedMillis = attrs.lastModifiedMillis();
            int offset = 0;
            offset = DefaultEntityTagFunction.appendInt(data, offset, hashCode);
            offset = DefaultEntityTagFunction.appendLong(data, offset, length);
            offset = DefaultEntityTagFunction.appendLong(data, offset, lastModifiedMillis);
            String string = offset != 0 ? etagEncoding.encode(data, 0, offset) : "-";
            return string;
        }
    }

    private static int appendLong(byte[] data, int offset, long value) {
        offset = DefaultEntityTagFunction.appendByte(data, offset, value >>> 56);
        offset = DefaultEntityTagFunction.appendByte(data, offset, value >>> 48);
        offset = DefaultEntityTagFunction.appendByte(data, offset, value >>> 40);
        offset = DefaultEntityTagFunction.appendByte(data, offset, value >>> 32);
        offset = DefaultEntityTagFunction.appendInt(data, offset, value);
        return offset;
    }

    private static int appendInt(byte[] data, int offset, long value) {
        offset = DefaultEntityTagFunction.appendByte(data, offset, value >>> 24);
        offset = DefaultEntityTagFunction.appendByte(data, offset, value >>> 16);
        offset = DefaultEntityTagFunction.appendByte(data, offset, value >>> 8);
        offset = DefaultEntityTagFunction.appendByte(data, offset, value);
        return offset;
    }

    private static int appendByte(byte[] dst, int offset, long value) {
        if (value == 0L) {
            return offset;
        }
        dst[offset] = (byte)value;
        return offset + 1;
    }
}

