/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource.etree;

import net.ripe.ipresource.etree.ChildNodeMap;
import net.ripe.ipresource.etree.ChildNodeTreeMap;
import net.ripe.ipresource.etree.IntervalStrategy;
import org.apache.commons.lang3.Validate;

final class InternalNode<K, V> {
    private final K key;
    private V value;
    private ChildNodeMap<K, V> children = ChildNodeTreeMap.empty();

    public InternalNode(K interval, V value) {
        Validate.notNull(interval, (String)"interval", (Object[])new Object[0]);
        Validate.notNull(value, (String)"value", (Object[])new Object[0]);
        this.key = interval;
        this.value = value;
    }

    public InternalNode(InternalNode<K, V> source, IntervalStrategy<K> strategy) {
        this.key = source.key;
        this.value = source.value;
        this.children = source.children == ChildNodeTreeMap.EMPTY ? ChildNodeTreeMap.empty() : new ChildNodeTreeMap<K, V>(source.children, strategy);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.children.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalNode that = (InternalNode)obj;
        return this.key.equals(that.key) && this.value.equals(that.value) && this.children.equals(that.children);
    }

    public String toString() {
        return "Node(" + this.key + ", " + this.value + ", " + this.children + ")";
    }

    ChildNodeMap<K, V> getChildren() {
        return this.children;
    }

    void addChild(InternalNode<K, V> nodeToAdd, IntervalStrategy<K> strategy) {
        if (this.key.equals(nodeToAdd.getKey())) {
            this.value = nodeToAdd.getValue();
        } else {
            if (!strategy.contains(this.key, nodeToAdd.getKey())) {
                throw new IllegalArgumentException(nodeToAdd.getKey() + " not properly contained in " + this.key);
            }
            if (this.children == ChildNodeTreeMap.EMPTY) {
                this.children = new ChildNodeTreeMap(strategy);
            }
            this.children.addChild(nodeToAdd, strategy);
        }
    }

    public void removeChild(K range, IntervalStrategy<K> strategy) {
        if (!strategy.contains(this.key, range) || this.key.equals(range)) {
            throw new IllegalArgumentException(range + " not properly contained in " + this.key);
        }
        if (this.children != ChildNodeTreeMap.EMPTY) {
            this.children.removeChild(range, strategy);
            if (this.children.isEmpty()) {
                this.children = ChildNodeTreeMap.empty();
            }
        }
    }
}

