/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.math.BigInteger;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class IpResourceRange
extends IpResource {
    private static final long serialVersionUID = 1L;
    private final UniqueIpResource start;
    private final UniqueIpResource end;

    public static IpResourceRange range(UniqueIpResource start, UniqueIpResource end) {
        if (start instanceof IpAddress && end instanceof IpAddress) {
            return IpRange.range((IpAddress)start, (IpAddress)end);
        }
        return new IpResourceRange(start, end);
    }

    protected IpResourceRange(UniqueIpResource start, UniqueIpResource end) {
        Validate.notNull((Object)start, (String)"start is null", (Object[])new Object[0]);
        Validate.notNull((Object)end, (String)"end is null", (Object[])new Object[0]);
        Validate.isTrue((start.getType() == end.getType() ? 1 : 0) != 0, (String)"resource types do not match", (Object[])new Object[0]);
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("range must not be empty: " + start + "-" + end);
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public UniqueIpResource getStart() {
        return this.start;
    }

    @Override
    public UniqueIpResource getEnd() {
        return this.end;
    }

    @Override
    public IpResourceType getType() {
        return this.start.getType();
    }

    @Override
    public boolean isValidNetmask() {
        return this.isUnique() && this.unique().isValidNetmask();
    }

    public String toString() {
        return this.start.toString() + "-" + this.end.toString();
    }

    @Override
    protected int doCompareTo(IpResource that) {
        if (that instanceof UniqueIpResource) {
            return -that.compareTo(this);
        }
        if (that instanceof IpResourceRange) {
            int rc = this.getStart().doCompareTo(that.getStart());
            if (rc != 0) {
                return rc;
            }
            return -this.getEnd().doCompareTo(that.getEnd());
        }
        throw new IllegalArgumentException("unknown resource type: " + that);
    }

    @Override
    protected int doHashCode() {
        return this.isUnique() ? this.unique().hashCode() : new HashCodeBuilder().append((Object)this.start).append((Object)this.end).toHashCode();
    }

    @Override
    public UniqueIpResource unique() {
        Validate.isTrue((boolean)this.isUnique(), (String)"resource not unique", (Object[])new Object[0]);
        return this.getStart();
    }

    public static IpResourceRange parse(String s) {
        if (s.indexOf(44) >= 0) {
            return IpResourceRange.parseCommaPrefixNotation(s);
        }
        if (s.indexOf(47) >= 0) {
            return IpResourceRange.parseAsSingleSlashNotatedRange(s);
        }
        if (s.indexOf(45) >= 0) {
            return IpResourceRange.parseAsRangeDenotedBySingleStartAndEndAddress(s);
        }
        throw new IllegalArgumentException("illegal resource range: " + s);
    }

    private static IpResourceRange parseAsRangeDenotedBySingleStartAndEndAddress(String s) {
        int idx = s.indexOf(45);
        UniqueIpResource start = UniqueIpResource.parse(s.substring(0, idx));
        UniqueIpResource end = UniqueIpResource.parse(s.substring(idx + 1));
        if (start.getType() != end.getType()) {
            throw new IllegalArgumentException("resource types in range do not match");
        }
        return IpResourceRange.range(start, end);
    }

    private static IpResourceRange parseAsSingleSlashNotatedRange(String s) {
        int idx = s.indexOf(47);
        IpAddress prefix = IpAddress.parse(s.substring(0, idx), true);
        int length = Integer.parseInt(s.substring(idx + 1));
        return IpRange.prefix(prefix, length);
    }

    private static IpResourceRange parseCommaPrefixNotation(String s) {
        int slashIdx = s.indexOf(47);
        if (slashIdx == -1) {
            throw new IllegalArgumentException("Comma separated notation can only be used for adjacent prefix notations like: 10.0.0.0/16,/24,/25,/31");
        }
        String startAddress = s.substring(0, slashIdx);
        UniqueIpResource start = UniqueIpResource.parse(startAddress);
        UniqueIpResource end = UniqueIpResource.parse(startAddress);
        String prefixSizeList = s.substring(slashIdx);
        int lastSeenPrefixMask = -1;
        for (String prefixStr : prefixSizeList.split(",")) {
            int prefixMask = Integer.parseInt(prefixStr.substring(1));
            if (lastSeenPrefixMask >= prefixMask) {
                throw new IllegalArgumentException("Mask of prefix " + prefixMask + " is bigger than previous: " + lastSeenPrefixMask);
            }
            end = end.upperBoundForPrefix(prefixMask).successor();
            lastSeenPrefixMask = prefixMask;
        }
        return IpResourceRange.range(start, end.predecessor());
    }

    public static IpResourceRange assemble(BigInteger start, BigInteger end, IpResourceType type) {
        return type.fromBigInteger(start).upTo(type.fromBigInteger(end));
    }

    public static IpResourceRange parseWithNetmask(String ipStr, String netmaskStr) {
        UniqueIpResource start = UniqueIpResource.parse(ipStr);
        UniqueIpResource netmask = UniqueIpResource.parse(netmaskStr);
        if (!netmask.isValidNetmask()) {
            throw new IllegalArgumentException("netmask '" + netmaskStr + "' is not a valid netmask");
        }
        int size = netmask.getValue().bitCount();
        IpAddress end = start.upperBoundForPrefix(size);
        return IpResourceRange.range(start, end);
    }
}

