/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.function.ChangeEntitiesHandler;
import org.apache.baremaps.openstreetmap.function.CoordinateMapBuilder;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.ReferenceMapBuilder;
import org.apache.baremaps.openstreetmap.stream.ConsumerUtils;
import org.apache.baremaps.openstreetmap.xml.XmlChangeReader;
import org.apache.baremaps.postgres.openstreetmap.CopyChangeImporter;
import org.apache.baremaps.postgres.openstreetmap.NodeRepository;
import org.apache.baremaps.postgres.openstreetmap.RelationRepository;
import org.apache.baremaps.postgres.openstreetmap.Repository;
import org.apache.baremaps.postgres.openstreetmap.WayRepository;
import org.apache.baremaps.utils.Compression;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportOsmOsc
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportOsmOsc.class);
    private Path file;
    private Compression compression;
    private Object database;
    private Integer databaseSrid;

    public ImportOsmOsc() {
    }

    public ImportOsmOsc(Path file, Compression compression, Object database, Integer databaseSrid) {
        this.file = file;
        this.compression = compression;
        this.database = database;
        this.databaseSrid = databaseSrid;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        DataSource datasource = context.getDataSource(this.database);
        NodeRepository nodeRepository = new NodeRepository(datasource);
        WayRepository wayRepository = new WayRepository(datasource);
        RelationRepository relationRepository = new RelationRepository(datasource);
        Map<Long, Coordinate> coordinateMap = context.getCoordinateMap();
        Map<Long, List<Long>> referenceMap = context.getReferenceMap();
        CoordinateMapBuilder coordinateMapBuilder = new CoordinateMapBuilder(coordinateMap);
        ReferenceMapBuilder referenceMapBuilder = new ReferenceMapBuilder(referenceMap);
        EntityGeometryBuilder buildGeometry = new EntityGeometryBuilder(coordinateMap, referenceMap);
        EntityProjectionTransformer reprojectGeometry = new EntityProjectionTransformer(4326, this.databaseSrid.intValue());
        Consumer prepareGeometries = coordinateMapBuilder.andThen((Consumer)referenceMapBuilder).andThen(buildGeometry).andThen(reprojectGeometry);
        UnaryOperator prepareChange = ConsumerUtils.consumeThenReturn((Consumer)new ChangeEntitiesHandler(prepareGeometries));
        CopyChangeImporter importChange = new CopyChangeImporter((Repository)nodeRepository, (Repository)wayRepository, (Repository)relationRepository);
        try (BufferedInputStream changeInputStream = new BufferedInputStream(this.compression.decompress(Files.newInputStream(path, new OpenOption[0])));){
            new XmlChangeReader().read((InputStream)changeInputStream).map(prepareChange).forEach(importChange);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportOsmOsc.class.getSimpleName() + "[", "]").add("file=" + String.valueOf(this.file)).add("compression=" + String.valueOf((Object)this.compression)).add("database=" + String.valueOf(this.database)).add("databaseSrid=" + this.databaseSrid).toString();
    }
}

