/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.internal.CommonDomainFinder;
import org.apache.sis.coverage.internal.RangeArgument;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.datum.PixelInCell;

public final class MultiSourceArgument<S> {
    private S[] sources;
    private int[][] bandsPerSource;
    private int[] numBandsPerSource;
    private int validatedSourceCount;
    private int totalBandCount;
    private List<SampleDimension> ranges;
    private long[][] gridTranslations;
    private int sourceOfGridToCRS = -1;
    private Consumer<Unwrapper> unwrapper;

    public MultiSourceArgument(S[] sources, int[][] bandsPerSource) {
        ArgumentChecks.ensureNonEmpty((String)"sources", (Object[])sources);
        int n = sources.length;
        if (bandsPerSource != null) {
            if (((int[][])bandsPerSource).length > n) {
                throw new IllegalArgumentException(Errors.format((short)35, (Object)"bandsPerSource", (Object)((int[][])bandsPerSource).length, (Object)n));
            }
            bandsPerSource = (int[][])Arrays.copyOf(bandsPerSource, n);
        } else {
            bandsPerSource = new int[n][];
        }
        this.sources = (Object[])sources.clone();
        this.bandsPerSource = bandsPerSource;
    }

    private void checkValidationState(boolean expected) {
        if (this.numBandsPerSource == null == expected) {
            throw new IllegalStateException();
        }
    }

    public void unwrap(Consumer<Unwrapper> filter) {
        this.checkValidationState(false);
        this.unwrapper = filter;
    }

    private boolean unwrap(int index, S source, int[] bands) {
        if (this.unwrapper == null) {
            return false;
        }
        Unwrapper handler = new Unwrapper(index, source, bands);
        this.unwrapper.accept(handler);
        return handler.done;
    }

    public void validate(ToIntFunction<S> counter) {
        this.checkValidationState(false);
        this.validate(null, Objects.requireNonNull(counter));
    }

    public void completeAndValidate(Function<S, List<SampleDimension>> getter) {
        this.checkValidationState(false);
        this.ranges = new ArrayList<SampleDimension>();
        this.validate(Objects.requireNonNull(getter), null);
    }

    private void validate(Function<S, List<SampleDimension>> getter, ToIntFunction<S> counter) {
        HashMap<Integer, int[]> identityPool = new HashMap<Integer, int[]>();
        this.numBandsPerSource = new int[this.sources.length];
        block0: for (int i = 0; i < this.sources.length; ++i) {
            int[] selected;
            while ((selected = this.bandsPerSource[i]) == null || selected.length != 0) {
                int[] previous;
                RangeArgument range;
                int numSourceBands;
                List<SampleDimension> sourceBands;
                S source = this.sources[i];
                ArgumentChecks.ensureNonNullElement((String)"sources", (int)i, source);
                if (getter != null) {
                    sourceBands = getter.apply(source);
                    numSourceBands = sourceBands.size();
                } else {
                    sourceBands = null;
                    numSourceBands = counter.applyAsInt(source);
                }
                if (this.unwrap(i, source, selected = (range = RangeArgument.validate(numSourceBands, selected, null)).getSelectedBands())) continue;
                if (this.validatedSourceCount >= this.numBandsPerSource.length) {
                    this.numBandsPerSource = Arrays.copyOf(this.numBandsPerSource, this.sources.length);
                }
                if (this.ranges != null) {
                    for (int j : selected) {
                        this.ranges.add(sourceBands.get(j));
                    }
                }
                if (range.isIdentity() && (previous = identityPool.putIfAbsent(numSourceBands, selected)) != null) {
                    selected = previous;
                }
                this.sources[this.validatedSourceCount] = source;
                this.bandsPerSource[this.validatedSourceCount] = selected;
                this.numBandsPerSource[this.validatedSourceCount] = numSourceBands;
                this.totalBandCount += range.getNumBands();
                ++this.validatedSourceCount;
                continue block0;
            }
        }
    }

    public void mergeConsecutiveSources() {
        this.checkValidationState(true);
        int i = 1;
        while (i < this.validatedSourceCount) {
            if (this.sources[i] == this.sources[i - 1]) {
                this.bandsPerSource[i - 1] = ArraysExt.concatenate((int[])this.bandsPerSource[i - 1], (int[])this.bandsPerSource[i]);
                int remaining = --this.validatedSourceCount - i;
                System.arraycopy(this.sources, i + 1, this.sources, i, remaining);
                System.arraycopy(this.bandsPerSource, i + 1, this.bandsPerSource, i, remaining);
                System.arraycopy(this.numBandsPerSource, i + 1, this.numBandsPerSource, i, remaining);
                continue;
            }
            ++i;
        }
    }

    public int[] mergeDuplicatedSources() {
        this.checkValidationState(true);
        IdentityHashMap<S, long[]> mergedBands = new IdentityHashMap<S, long[]>();
        int targetBand = 0;
        for (int i = 0; i < this.validatedSourceCount; ++i) {
            int[] selected = this.bandsPerSource[i];
            long[] tuples = new long[selected.length];
            for (int j = 0; j < selected.length; ++j) {
                tuples[j] = Numerics.tuple((int)selected[j], (int)targetBand++);
            }
            mergedBands.merge(this.sources[i], tuples, ArraysExt::concatenate);
        }
        int[] reordered = new int[this.totalBandCount];
        int count = this.validatedSourceCount;
        this.validatedSourceCount = 0;
        targetBand = 0;
        for (int i = 0; i < count; ++i) {
            S source = this.sources[i];
            long[] tuples = (long[])mergedBands.remove(source);
            if (tuples == null) continue;
            int[] selected = this.bandsPerSource[i];
            if (tuples.length > selected.length) {
                Arrays.sort(tuples);
                selected = new int[tuples.length];
            }
            for (int j = 0; j < tuples.length; ++j) {
                long t = tuples[j];
                reordered[(int)t] = targetBand + j;
                selected[j] = (int)(t >>> 32);
            }
            targetBand += tuples.length;
            this.numBandsPerSource[this.validatedSourceCount] = this.numBandsPerSource[i];
            this.bandsPerSource[this.validatedSourceCount] = selected;
            this.sources[this.validatedSourceCount++] = source;
        }
        return reordered;
    }

    public boolean isIdentity() {
        this.checkValidationState(true);
        return this.validatedSourceCount == 1 && this.isIdentity(0);
    }

    private boolean isIdentity(int i) {
        int[] selected = this.bandsPerSource[i];
        return selected.length == this.numBandsPerSource[i] && ArraysExt.isRange((int)0, (int[])selected);
    }

    public S[] sources() {
        this.checkValidationState(true);
        this.sources = ArraysExt.resize((Object[])this.sources, (int)this.validatedSourceCount);
        return this.sources;
    }

    public int[][] bandsPerSource(boolean identityAsNull) {
        this.checkValidationState(true);
        this.bandsPerSource = (int[][])ArraysExt.resize((Object[])this.bandsPerSource, (int)this.validatedSourceCount);
        if (identityAsNull) {
            for (int i = 0; i < this.validatedSourceCount; ++i) {
                if (!this.isIdentity(i)) continue;
                this.bandsPerSource[i] = null;
            }
        }
        return this.bandsPerSource;
    }

    public int numBands() {
        this.checkValidationState(true);
        return this.totalBandCount;
    }

    public List<SampleDimension> ranges() {
        if (this.ranges != null) {
            return this.ranges;
        }
        throw new IllegalStateException();
    }

    public GridGeometry domain(Function<S, GridGeometry> getter) {
        this.checkValidationState(true);
        CommonDomainFinder finder = new CommonDomainFinder(PixelInCell.CELL_CORNER);
        finder.setFromGridAligned((GridGeometry[])Arrays.stream(this.sources).map(getter).toArray(GridGeometry[]::new));
        this.sourceOfGridToCRS = finder.sourceOfGridToCRS();
        this.gridTranslations = finder.gridTranslations();
        return finder.result();
    }

    public long[][] gridTranslations() {
        this.checkValidationState(true);
        return this.gridTranslations;
    }

    public int sourceOfGridToCRS() {
        this.checkValidationState(true);
        return this.sourceOfGridToCRS;
    }

    public final class Unwrapper {
        private final int index;
        public final S source;
        public final int[] bands;
        private boolean done;

        private Unwrapper(int index, S source, int[] bands) {
            this.index = index;
            this.source = source;
            this.bands = bands;
        }

        public void applySubset(S[] sources, int[][] bandsPerSource, Function<S, List<SampleDimension>> getter) {
            Object[] components = (Object[])Array.newInstance(sources.getClass().getComponentType(), this.bands.length);
            int[][] componentBands = new int[this.bands.length][];
            int sourceIndex = -1;
            int[] sourceBands = null;
            Object component = null;
            int lower = 0;
            int upper = 0;
            for (int i = 0; i < this.bands.length; ++i) {
                int band = this.bands[i];
                if (band < lower) {
                    upper = 0;
                    lower = 0;
                    sourceIndex = -1;
                }
                while (band >= upper) {
                    component = sources[++sourceIndex];
                    sourceBands = bandsPerSource[sourceIndex];
                    lower = upper;
                    upper += sourceBands != null ? sourceBands.length : getter.apply(component).size();
                }
                band -= lower;
                if (sourceBands != null) {
                    band = sourceBands[band];
                }
                componentBands[i] = new int[]{band};
                components[i] = component;
            }
            this.apply(components, componentBands);
        }

        public void apply(S[] components, int[][] componentBands) {
            int n = components.length;
            if (componentBands.length != n) {
                throw new IllegalArgumentException(Errors.format((short)77));
            }
            if (this.done) {
                throw new IllegalStateException();
            }
            MultiSourceArgument.this.sources = ArraysExt.insert((Object[])MultiSourceArgument.this.sources, (int)(this.index + 1), (int)(n - 1));
            MultiSourceArgument.this.bandsPerSource = (int[][])ArraysExt.insert((Object[])MultiSourceArgument.this.bandsPerSource, (int)(this.index + 1), (int)(n - 1));
            System.arraycopy(components, 0, MultiSourceArgument.this.sources, this.index, n);
            System.arraycopy(componentBands, 0, MultiSourceArgument.this.bandsPerSource, this.index, n);
            this.done = true;
        }
    }
}

