/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.model;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.StringJoiner;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.baremaps.osm.binary.Fileformat;

public final class Blob {
    private final Fileformat.BlobHeader header;
    private final byte[] rawData;
    private final int size;

    public Blob(Fileformat.BlobHeader header, byte[] rawData, int size) {
        this.header = header;
        this.rawData = rawData;
        this.size = size;
    }

    public Fileformat.BlobHeader header() {
        return this.header;
    }

    public ByteString data() throws DataFormatException, InvalidProtocolBufferException {
        Fileformat.Blob blob = Fileformat.Blob.parseFrom(this.rawData);
        if (blob.hasRaw()) {
            return blob.getRaw();
        }
        if (blob.hasZlibData()) {
            byte[] bytes = new byte[blob.getRawSize()];
            Inflater inflater = new Inflater();
            inflater.setInput(blob.getZlibData().toByteArray());
            inflater.inflate(bytes);
            inflater.end();
            return ByteString.copyFrom((byte[])bytes);
        }
        throw new DataFormatException("Unsupported toPrimitiveBlock format");
    }

    public long size() {
        return this.size;
    }

    public String toString() {
        return new StringJoiner(", ", Blob.class.getSimpleName() + "[", "]").add("header=" + String.valueOf(this.header)).add("size=" + this.size).toString();
    }
}

