/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.columns;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.db.TableColumnKey;
import mil.nga.geopackage.features.columns.GeometryColumnsSfSql;

public class GeometryColumnsSfSqlDao
extends GeoPackageDao<GeometryColumnsSfSql, TableColumnKey> {
    public static GeometryColumnsSfSqlDao create(GeoPackageCore geoPackage) {
        return GeometryColumnsSfSqlDao.create(geoPackage.getDatabase());
    }

    public static GeometryColumnsSfSqlDao create(GeoPackageCoreConnection db) {
        GeometryColumnsSfSqlDao dao = (GeometryColumnsSfSqlDao)((Object)GeoPackageDao.createDao(db, GeometryColumnsSfSql.class));
        dao.verifyExists();
        return dao;
    }

    public GeometryColumnsSfSqlDao(ConnectionSource connectionSource, Class<GeometryColumnsSfSql> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public GeometryColumnsSfSql queryForId(TableColumnKey key) throws SQLException {
        GeometryColumnsSfSql geometryColumns = null;
        if (key != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("f_table_name", key.getTableName());
            fieldValues.put("f_geometry_column", key.getColumnName());
            List results = this.queryForFieldValues(fieldValues);
            if (!results.isEmpty()) {
                if (results.size() > 1) {
                    throw new SQLException("More than one " + GeometryColumnsSfSql.class.getSimpleName() + " returned for key. Table Name: " + key.getTableName() + ", Column Name: " + key.getColumnName());
                }
                geometryColumns = (GeometryColumnsSfSql)results.get(0);
            }
        }
        return geometryColumns;
    }

    public TableColumnKey extractId(GeometryColumnsSfSql data) throws SQLException {
        return data.getId();
    }

    public boolean idExists(TableColumnKey id) throws SQLException {
        return this.queryForId(id) != null;
    }

    public GeometryColumnsSfSql queryForSameId(GeometryColumnsSfSql data) throws SQLException {
        return this.queryForId(data.getId());
    }

    public int updateId(GeometryColumnsSfSql data, TableColumnKey newId) throws SQLException {
        int count = 0;
        GeometryColumnsSfSql readData = this.queryForId(data.getId());
        if (readData != null && newId != null) {
            readData.setId(newId);
            count = this.update(readData);
        }
        return count;
    }

    public int delete(GeometryColumnsSfSql data) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("f_table_name", (Object)data.getFTableName()).and().eq("f_geometry_column", (Object)data.getFGeometryColumn());
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public int deleteById(TableColumnKey id) throws SQLException {
        GeometryColumnsSfSql geometryColumns;
        int count = 0;
        if (id != null && (geometryColumns = this.queryForId(id)) != null) {
            count = this.delete(geometryColumns);
        }
        return count;
    }

    public int deleteIds(Collection<TableColumnKey> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (TableColumnKey id : idCollection) {
                count += this.deleteById(id);
            }
        }
        return count;
    }

    public int update(GeometryColumnsSfSql geometryColumns) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("geometry_type", (Object)geometryColumns.getGeometryTypeCode());
        ub.updateColumnValue("coord_dimension", (Object)geometryColumns.getCoordDimension());
        ub.updateColumnValue("srid", (Object)geometryColumns.getSrid());
        ub.where().eq("f_table_name", (Object)geometryColumns.getFTableName()).and().eq("f_geometry_column", (Object)geometryColumns.getFGeometryColumn());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }
}

