/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.internal;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public final class NameToIdentifier
implements ReferenceIdentifier {
    private final GenericName name;

    public NameToIdentifier(GenericName name) {
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        this.name = name;
    }

    private static GenericName scope(GenericName name) {
        NameSpace scope;
        if (name != null && (scope = name.scope()) != null && !scope.isGlobal()) {
            return scope.name();
        }
        return null;
    }

    public Citation getAuthority() {
        GenericName scope = NameToIdentifier.scope(this.name);
        if (scope == null && (scope = NameToIdentifier.scope((GenericName)this.name.tip())) == null) {
            return null;
        }
        return Citations.fromName(scope.head().toString());
    }

    public static String getCodeSpace(GenericName name, Locale locale) {
        GenericName scope = NameToIdentifier.scope((GenericName)name.tip());
        return scope != null ? NameToIdentifier.toString((GenericName)scope.tip(), locale) : null;
    }

    public String getCodeSpace() {
        return NameToIdentifier.getCodeSpace(this.name, null);
    }

    public String getCode() {
        return this.name.tip().toString();
    }

    public String getVersion() {
        return null;
    }

    public int hashCode() {
        return ~Objects.hashCode(this.name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return Objects.equals(this.name, ((NameToIdentifier)object).name);
        }
        return false;
    }

    public String toString() {
        String code = this.getCode();
        String cs = this.getCodeSpace();
        if (cs != null && !cs.isEmpty()) {
            return cs + ":" + code;
        }
        return code;
    }

    public static String toString(GenericName name, Locale locale) {
        if (name != null) {
            String s;
            InternationalString i18n;
            if (locale != null && (i18n = name.toInternationalString()) != null && (s = i18n.toString(locale)) != null) {
                return s;
            }
            return name.toString();
        }
        return null;
    }

    public static boolean isHeuristicMatchForIdentifier(Iterable<? extends ReferenceIdentifier> identifiers, String toSearch) {
        if (toSearch != null && identifiers != null) {
            int s = toSearch.indexOf(58);
            if (s < 0) {
                for (Identifier identifier : identifiers) {
                    if (!toSearch.equalsIgnoreCase(identifier.getCode())) continue;
                    return true;
                }
                return false;
            }
            do {
                String codespace = toSearch.substring(0, s).trim();
                String string = toSearch.substring(++s).trim();
                for (ReferenceIdentifier referenceIdentifier : identifiers) {
                    if (!codespace.equalsIgnoreCase(referenceIdentifier.getCodeSpace()) || !string.equalsIgnoreCase(referenceIdentifier.getCode())) continue;
                    return true;
                }
            } while ((s = toSearch.indexOf(58, s)) >= 0);
        }
        return false;
    }

    public static boolean isHeuristicMatchForName(Identifier name, Collection<GenericName> aliases, CharSequence toSearch, Simplifier simplifier) {
        if (toSearch != null) {
            CharSequence code;
            String string = code = name != null ? name.getCode() : null;
            if (toSearch.equals(code)) {
                return true;
            }
            if (CharSequences.equalsFiltered((CharSequence)(toSearch = simplifier.apply(toSearch)), (CharSequence)(code = simplifier.apply(code)), (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) {
                return true;
            }
            if (aliases != null) {
                for (GenericName alias : aliases) {
                    CharSequence tip;
                    if (alias == null || !CharSequences.equalsFiltered((CharSequence)toSearch, (CharSequence)(tip = simplifier.apply(alias.tip().toString())), (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject object, String name) {
        return NameToIdentifier.isHeuristicMatchForName((Identifier)object.getName(), object.getAlias(), name, Simplifier.DEFAULT);
    }

    public static class Simplifier {
        public static final String ESRI_DATUM_PREFIX = "D_";
        public static final Simplifier DEFAULT = new Simplifier();

        protected Simplifier() {
        }

        protected CharSequence apply(CharSequence name) {
            return CharSequences.toASCII((CharSequence)name);
        }
    }
}

