/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedFeatureSet;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;

public class ConcatenatedFeatureSet
extends AggregatedFeatureSet {
    private final List<FeatureSet> sources;
    private final DefaultFeatureType commonType;

    private ConcatenatedFeatureSet(FeatureSet[] sources, ConcatenatedFeatureSet original) {
        super(original.listeners);
        this.sources = UnmodifiableArrayList.wrap((Object[])sources);
        this.commonType = original.commonType;
    }

    protected ConcatenatedFeatureSet(Resource parent, FeatureSet[] sources) throws DataStoreException {
        super(parent);
        for (int i = 0; i < sources.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"sources", (int)i, (Object)sources[i]);
        }
        this.sources = UnmodifiableArrayList.wrap((Object[])sources);
        DefaultFeatureType[] types = new DefaultFeatureType[sources.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = sources[i].getType();
        }
        this.commonType = Features.findCommonParent(Arrays.asList(types));
        if (this.commonType == null) {
            throw new DataStoreContentException(Resources.format((short)75));
        }
    }

    public static FeatureSet create(FeatureSet ... sources) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty((String)"sources", (Object[])sources);
        if (sources.length == 1) {
            FeatureSet fs = sources[0];
            ArgumentChecks.ensureNonNullElement((String)"sources", (int)0, (Object)fs);
            return fs;
        }
        return new ConcatenatedFeatureSet(null, (FeatureSet[])sources.clone());
    }

    public static FeatureSet create(Collection<? extends FeatureSet> sources) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"sources", sources);
        int size = sources.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)29, (Object)"sources"));
            }
            case 1: {
                FeatureSet fs = (FeatureSet)CollectionsExt.first(sources);
                ArgumentChecks.ensureNonNullElement((String)"sources", (int)0, (Object)fs);
                return fs;
            }
        }
        return new ConcatenatedFeatureSet(null, sources.toArray(new FeatureSet[size]));
    }

    final List<FeatureSet> dependencies() {
        return this.sources;
    }

    @Override
    public DefaultFeatureType getType() {
        return this.commonType;
    }

    @Override
    public OptionalLong getFeatureCount() {
        long sum = 0L;
        for (FeatureSet fs : this.sources) {
            long c;
            OptionalLong count;
            if (fs instanceof AbstractFeatureSet && (count = ((AbstractFeatureSet)fs).getFeatureCount()).isPresent() && (c = count.getAsLong()) >= 0L) {
                if ((sum += c) >= 0L) continue;
                sum = Long.MAX_VALUE;
                break;
            }
            return OptionalLong.empty();
        }
        return OptionalLong.of(sum);
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) {
        Stream sets = parallel ? this.sources.parallelStream() : this.sources.stream();
        return sets.flatMap(set -> {
            try {
                return set.features(parallel);
            }
            catch (DataStoreException e) {
                throw new BackingStoreException((Throwable)e);
            }
        });
    }

    @Override
    public FeatureSet subset(Query query) throws DataStoreException {
        FeatureSet[] subsets = new FeatureSet[this.sources.size()];
        boolean modified = false;
        for (int i = 0; i < subsets.length; ++i) {
            FeatureSet source = this.sources.get(i);
            subsets[i] = source.subset(query);
            modified |= subsets[i] != source;
        }
        return modified ? new ConcatenatedFeatureSet(subsets, this) : this;
    }
}

