/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.dns;

import com.linecorp.armeria.client.DnsTimeoutException;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.client.dns.DnsQuestionContext;
import com.linecorp.armeria.internal.client.dns.DnsResolver;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DelegatingDnsResolver
implements DnsResolver {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingDnsResolver.class);
    private static final List<DnsRecord> EMPTY_ADDITIONALS = ImmutableList.of();
    private final DnsNameResolver delegate;
    private final EventExecutor executor;

    DelegatingDnsResolver(DnsNameResolver delegate, EventExecutor executor) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    @Override
    public CompletableFuture<List<DnsRecord>> resolve(DnsQuestionContext ctx, DnsQuestion question) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(question, "question");
        if (ctx.isCancelled()) {
            return UnmodifiableFuture.exceptionallyCompletedFuture(new DnsTimeoutException(question + " is timed out after " + ctx.queryTimeoutMillis() + " milliseconds."));
        }
        logger.debug("[{}] Sending a DNS query: {}", (Object)question.name(), (Object)question);
        return UnmodifiableFuture.fromNetty(this.delegate.resolveAll(question, EMPTY_ADDITIONALS, this.executor.newPromise()));
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

