/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.CookieUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.handler.codec.DateFormatter;
import java.util.Date;
import java.util.Objects;

final class ServerCookieEncoder {
    static String encode(boolean strict, Cookie cookie) {
        String sameSite;
        String domain;
        String path;
        String name = Objects.requireNonNull(cookie, "cookie").name();
        String value = MoreObjects.firstNonNull(cookie.value(), "");
        CookieUtil.validateCookie(strict, name, value);
        StringBuilder buf = CookieUtil.stringBuilder();
        if (cookie.isValueQuoted()) {
            CookieUtil.addQuoted(buf, name, value);
        } else {
            CookieUtil.add(buf, name, value);
        }
        if (cookie.maxAge() != Long.MIN_VALUE) {
            CookieUtil.add(buf, "Max-Age", cookie.maxAge());
            Date expires = new Date(cookie.maxAge() * 1000L + System.currentTimeMillis());
            buf.append("Expires");
            buf.append('=');
            DateFormatter.append((Date)expires, (StringBuilder)buf);
            buf.append(';');
            buf.append(' ');
        }
        if ((path = cookie.path()) != null) {
            CookieUtil.add(buf, "Path", path);
        }
        if ((domain = cookie.domain()) != null) {
            CookieUtil.add(buf, "Domain", domain);
        }
        if (cookie.isSecure()) {
            CookieUtil.add(buf, "Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieUtil.add(buf, "HTTPOnly");
        }
        if ((sameSite = cookie.sameSite()) != null) {
            CookieUtil.add(buf, "SameSite", sameSite);
        }
        return CookieUtil.stripTrailingSeparator(buf);
    }

    private ServerCookieEncoder() {
    }
}

