/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.AWSS3IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.services.s3.model.S3Exception;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class MultiObjectDeleteException
extends S3Exception {
    private static final Logger LOG = LoggerFactory.getLogger(MultiObjectDeleteException.class);
    public static final String ACCESS_DENIED = "AccessDenied";
    private static final int STATUS_CODE = 200;
    private static final String ERROR_CODE = "MultiObjectDeleteException";
    private static final String SERVICE_NAME = "Amazon S3";
    private final List<S3Error> errors;

    public MultiObjectDeleteException(List<S3Error> errors) {
        super(MultiObjectDeleteException.builder().message(errors.toString()).awsErrorDetails(AwsErrorDetails.builder().errorCode(ERROR_CODE).errorMessage(ERROR_CODE).serviceName(SERVICE_NAME).sdkHttpResponse((SdkHttpResponse)SdkHttpResponse.builder().statusCode(200).build()).build()).statusCode(200));
        this.errors = errors;
    }

    public List<S3Error> errors() {
        return this.errors;
    }

    public IOException translateException(String message) {
        LOG.info("Bulk delete operation failed to delete all objects; failure count = {}", (Object)this.errors().size());
        StringBuilder result = new StringBuilder(this.errors().size() * 256);
        result.append(message).append(": ");
        String exitCode = "";
        for (S3Error error : this.errors()) {
            String code = error.code();
            String item = String.format("%s: %s%s: %s%n", code, error.key(), error.versionId() != null ? " (" + error.versionId() + ")" : "", error.message());
            LOG.info(item);
            result.append(item);
            if (exitCode != null && !exitCode.isEmpty() && !ACCESS_DENIED.equals(code)) continue;
            exitCode = code;
        }
        if (ACCESS_DENIED.equals(exitCode)) {
            return (IOException)new AccessDeniedException(result.toString()).initCause((Throwable)((Object)this));
        }
        return new AWSS3IOException(result.toString(), this);
    }
}

