/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.baremaps.geocoder.geonames.GeonamesDocumentMapper;
import org.apache.baremaps.geocoder.geonames.GeonamesReader;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGeonamesIndex
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(CreateGeonamesIndex.class);
    private Path dataFile;
    private Path indexDirectory;

    public CreateGeonamesIndex() {
    }

    public CreateGeonamesIndex(Path dataFile, Path indexDirectory) {
        this.dataFile = dataFile;
        this.indexDirectory = indexDirectory;
    }

    @Override
    public void execute(WorkflowContext context) throws IOException {
        FSDirectory directory = FSDirectory.open((Path)this.indexDirectory);
        IndexWriterConfig config = new IndexWriterConfig(GeocoderConstants.ANALYZER);
        try (IndexWriter indexWriter = new IndexWriter((Directory)directory, config);
             InputStream inputStream = Files.newInputStream(this.dataFile, new OpenOption[0]);){
            indexWriter.deleteAll();
            Stream<Document> documents = new GeonamesReader().stream(inputStream).map(new GeonamesDocumentMapper());
            indexWriter.addDocuments(documents::iterator);
        }
    }

    public String toString() {
        return new StringJoiner(", ", CreateGeonamesIndex.class.getSimpleName() + "[", "]").add("dataFile=" + this.dataFile).add("indexDirectory=" + this.indexDirectory).toString();
    }
}

