/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.GeoPackageManager;
import mil.nga.geopackage.features.index.FeatureIndexManager;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.io.GeoPackageTextOutput;
import mil.nga.geopackage.io.TileReproject;
import mil.nga.geopackage.io.ZoomLevelProgress;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.features.DefaultFeatureTiles;
import mil.nga.geopackage.tiles.features.FeatureTileGenerator;
import mil.nga.geopackage.tiles.features.FeatureTilePointIcon;
import mil.nga.geopackage.tiles.features.FeatureTiles;
import mil.nga.geopackage.tiles.features.custom.NumberFeaturesTile;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.sf.proj.GeometryTransform;
import org.locationtech.proj4j.units.Units;

public class FeatureTileGen {
    private static final Logger LOGGER = Logger.getLogger(FeatureTileGen.class.getName());
    private static final int LOG_INDEX_FREQUENCY = 1000;
    private static final int LOG_INDEX_TIME_FREQUENCY = 10;
    private static final int LOG_TILE_FREQUENCY = 1000;
    private static final int LOG_TILE_TIME_FREQUENCY = 60;
    private static final int DEFAULT_MAX_FEATURES_PER_TILE = 5000;
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_MAX_FEATURES_PER_TILE = "m";
    public static final String ARGUMENT_COMPRESS_FORMAT = "f";
    public static final String ARGUMENT_COMPRESS_QUALITY = "q";
    public static final String ARGUMENT_XYZ_TILES = "xyz";
    public static final String ARGUMENT_BOUNDING_BOX = "bbox";
    public static final String ARGUMENT_EPSG = "epsg";
    public static final String ARGUMENT_TILE_WIDTH = "tileWidth";
    public static final String ARGUMENT_TILE_HEIGHT = "tileHeight";
    public static final String ARGUMENT_TILE_SCALE = "tileScale";
    public static final String ARGUMENT_POINT_RADIUS = "pointRadius";
    public static final String ARGUMENT_POINT_COLOR = "pointColor";
    public static final String ARGUMENT_POINT_ICON = "pointIcon";
    public static final String ARGUMENT_ICON_WIDTH = "iconWidth";
    public static final String ARGUMENT_ICON_HEIGHT = "iconHeight";
    public static final String ARGUMENT_POINT_CENTER_ICON = "centerIcon";
    public static final String ARGUMENT_LINE_STROKE_WIDTH = "lineStrokeWidth";
    public static final String ARGUMENT_LINE_COLOR = "lineColor";
    public static final String ARGUMENT_POLYGON_STROKE_WIDTH = "polygonStrokeWidth";
    public static final String ARGUMENT_POLYGON_COLOR = "polygonColor";
    public static final String ARGUMENT_FILL_POLYGON = "fillPolygon";
    public static final String ARGUMENT_POLYGON_FILL_COLOR = "polygonFillColor";
    public static final String ARGUMENT_SIMPLIFY_GEOMETRIES = "simplifyGeometries";
    public static final String ARGUMENT_GEODESIC = "geodesic";
    public static final String ARGUMENT_IGNORE_GEOPACKAGE_STYLES = "ignoreGeoPackageStyles";
    public static final String ARGUMENT_LOG_COUNT = "logCount";
    public static final String ARGUMENT_LOG_TIME = "logTime";
    private static ZoomLevelProgress progress = new ZoomLevelProgress("Feature Tile Generation", "tiles", 1000, 60);
    private static File featureGeoPackageFile = null;
    private static GeoPackage featureGeoPackage = null;
    private static String featureTable = null;
    private static File tileGeoPackageFile = null;
    private static GeoPackage tileGeoPackage = null;
    private static String tileTable = null;
    private static String zoomValue = null;
    private static Integer maxZoom = null;
    private static List<Long> zoomLevels = null;
    private static Integer maxFeaturesPerTile = 5000;
    private static String compressFormat = null;
    private static Float compressQuality = null;
    private static boolean xyzTiles = false;
    private static BoundingBox boundingBox = null;
    private static Long epsg = null;
    private static Integer tileWidth = null;
    private static Integer tileHeight = null;
    private static Float tileScale = null;
    private static Float pointRadius = null;
    private static Color pointColor = null;
    private static FeatureTilePointIcon icon = null;
    private static Integer iconWidth = null;
    private static Integer iconHeight = null;
    private static boolean centerIcon = false;
    private static Float lineStrokeWidth = null;
    private static Color lineColor = null;
    private static Float polygonStrokeWidth = null;
    private static Color polygonColor = null;
    private static Boolean fillPolygon = null;
    private static Color polygonFillColor = null;
    private static boolean simplifyGeometries = true;
    private static boolean geodesic = false;
    private static boolean ignoreGeoPackageStyles = false;

    public static void main(String[] args) {
        final Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                progress.cancel();
                try {
                    mainThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to wait for the main thread to finish", e);
                }
            }
        });
        boolean valid = true;
        boolean requiredArguments = false;
        for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "m": {
                        if (i + 1 < args.length) {
                            int max;
                            if ((max = Integer.valueOf(args[++i]).intValue()) >= 0) {
                                maxFeaturesPerTile = max;
                                break;
                            }
                            maxFeaturesPerTile = null;
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Max Features Per Tile argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "f": {
                        if (i + 1 < args.length) {
                            compressFormat = args[++i];
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Compress Format argument '" + arg + "' must be followed by an image format");
                        break;
                    }
                    case "q": {
                        if (i + 1 < args.length) {
                            compressQuality = Float.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Compress Quality argument '" + arg + "' must be followed by a value between 0.0 and 1.0");
                        break;
                    }
                    case "xyz": {
                        xyzTiles = true;
                        break;
                    }
                    case "bbox": {
                        if (i + 1 < args.length) {
                            String bbox;
                            String[] bboxParts;
                            if ((bboxParts = (bbox = args[++i]).split(",")).length != 4) {
                                valid = false;
                                System.out.println("Error: Bounding Box argument '" + arg + "' value must be in the format: minLon,minLat,maxLon,maxLat");
                                break;
                            }
                            double minLon = Double.valueOf(bboxParts[0]);
                            double minLat = Double.valueOf(bboxParts[1]);
                            double maxLon = Double.valueOf(bboxParts[2]);
                            double maxLat = Double.valueOf(bboxParts[3]);
                            boundingBox = new BoundingBox(minLon, minLat, maxLon, maxLat);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Bounding Box argument '" + arg + "' must be followed by bbox values: minLon,minLat,maxLon,maxLat");
                        break;
                    }
                    case "epsg": {
                        if (i + 1 < args.length) {
                            epsg = Long.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: EPSG argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "tileWidth": {
                        if (i + 1 < args.length) {
                            tileWidth = Integer.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Tile Width argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "tileHeight": {
                        if (i + 1 < args.length) {
                            tileHeight = Integer.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Tile Height argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "tileScale": {
                        if (i + 1 < args.length) {
                            tileScale = Float.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Tile Scale argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "pointRadius": {
                        if (i + 1 < args.length) {
                            pointRadius = Float.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Point Radius argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "pointColor": {
                        if (i + 1 < args.length) {
                            pointColor = FeatureTileGen.getColor(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Point Color argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "pointIcon": {
                        if (i + 1 < args.length) {
                            File pointIconFile = new File(args[++i]);
                            try {
                                BufferedImage iconImage = ImageIO.read(pointIconFile);
                                icon = new FeatureTilePointIcon(iconImage);
                                break;
                            }
                            catch (IOException e) {
                                throw new GeoPackageException("Failed to create point icon from image file: " + pointIconFile.getAbsolutePath(), (Throwable)e);
                            }
                        }
                        valid = false;
                        System.out.println("Error: Point Icon argument '" + arg + "' must be followed by a point image file");
                        break;
                    }
                    case "iconWidth": {
                        if (i + 1 < args.length) {
                            iconWidth = Integer.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Icon Width argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "iconHeight": {
                        if (i + 1 < args.length) {
                            iconHeight = Integer.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Icon Height argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "centerIcon": {
                        centerIcon = true;
                        break;
                    }
                    case "lineStrokeWidth": {
                        if (i + 1 < args.length) {
                            lineStrokeWidth = Float.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Line Stroke Width argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "lineColor": {
                        if (i + 1 < args.length) {
                            lineColor = FeatureTileGen.getColor(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Line Color argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "polygonStrokeWidth": {
                        if (i + 1 < args.length) {
                            polygonStrokeWidth = Float.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Polygon Stroke Width argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "polygonColor": {
                        if (i + 1 < args.length) {
                            polygonColor = FeatureTileGen.getColor(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Polygon Color argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "fillPolygon": {
                        fillPolygon = true;
                        break;
                    }
                    case "polygonFillColor": {
                        if (i + 1 < args.length) {
                            polygonFillColor = FeatureTileGen.getColor(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Polygon Fill Color argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "simplifyGeometries": {
                        if (i + 1 < args.length) {
                            simplifyGeometries = Boolean.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Simplify Geometries argument '" + arg + "' must be followed by a boolean value");
                        break;
                    }
                    case "geodesic": {
                        if (i + 1 < args.length) {
                            geodesic = Boolean.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Geodesic argument '" + arg + "' must be followed by a boolean value");
                        break;
                    }
                    case "ignoreGeoPackageStyles": {
                        if (i + 1 < args.length) {
                            ignoreGeoPackageStyles = Boolean.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Ignore GeoPackage Styles argument '" + arg + "' must be followed by a boolean value");
                        break;
                    }
                    case "logCount": {
                        if (i + 1 < args.length) {
                            progress.setCountFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Count argument '" + arg + "' must be followed by a frequency count value");
                        break;
                    }
                    case "logTime": {
                        if (i + 1 < args.length) {
                            progress.setTimeFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Time argument '" + arg + "' must be followed by a frequency time value in seconds");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (featureGeoPackageFile == null) {
                featureGeoPackageFile = new File(arg);
                continue;
            }
            if (featureTable == null) {
                featureTable = arg;
                continue;
            }
            if (tileGeoPackageFile == null) {
                tileGeoPackageFile = new File(arg);
                continue;
            }
            if (tileTable == null) {
                tileTable = arg;
                continue;
            }
            if (zoomValue == null) {
                zoomValue = arg;
                requiredArguments = true;
                continue;
            }
            if (maxZoom == null) {
                maxZoom = Integer.valueOf(arg);
                continue;
            }
            valid = false;
            System.out.println("Error: Unsupported extra argument: " + arg);
        }
        if (zoomValue != null) {
            if (maxZoom != null) {
                zoomValue = zoomValue + ARGUMENT_PREFIX + maxZoom;
            }
            if ((zoomLevels = TileReproject.parseZoomLevels(zoomValue)) == null) {
                System.out.println("Error: Invalid zoom level(s) or range: " + zoomValue);
                valid = false;
            }
        }
        if (compressFormat == null && compressQuality != null) {
            System.out.println("Error: Compress quality requires a compress format");
            valid = false;
        } else if (boundingBox == null && epsg != null) {
            System.out.println("Error: EPSG requires a bounding box");
            valid = false;
        }
        if ((pointRadius != null || pointColor != null) && icon != null) {
            System.out.println("Error: Point radius and/or color can not be specified together with a point icon");
            valid = false;
        }
        if (iconWidth != null || iconHeight != null) {
            if (icon == null) {
                System.out.println("Error: Point icon file must be specified when attempting to set an icon width or height");
                valid = false;
            } else {
                if (iconWidth == null) {
                    iconWidth = Math.round((float)icon.getWidth() * ((float)iconHeight.intValue() / (float)icon.getHeight()));
                } else if (iconHeight == null) {
                    iconHeight = Math.round((float)icon.getHeight() * ((float)iconWidth.intValue() / (float)icon.getWidth()));
                }
                icon.setWidth(iconWidth);
                icon.setHeight(iconHeight);
            }
        }
        if (centerIcon) {
            if (icon == null) {
                System.out.println("Error: Point icon file must be specified when attempting to center it");
                valid = false;
            } else {
                icon.centerIcon();
            }
        }
        if (!(fillPolygon != null && fillPolygon.booleanValue() || polygonFillColor == null)) {
            System.out.println("Error: Polygon Fill Color can only be specified when Fill Polygon is enabled");
            valid = false;
        }
        if (!valid || !requiredArguments) {
            FeatureTileGen.printUsage();
        } else {
            try {
                FeatureTileGen.generate();
            }
            catch (Exception e) {
                FeatureTileGen.printUsage();
                throw e;
            }
        }
    }

    private static Color getColor(String colorString) {
        Color color = null;
        String[] colorParts = colorString.split(",");
        try {
            switch (colorParts.length) {
                case 1: {
                    Field field = Color.class.getField(colorString);
                    color = (Color)field.get(null);
                    break;
                }
                case 3: {
                    color = new Color(Integer.parseInt(colorParts[0]), Integer.parseInt(colorParts[1]), Integer.parseInt(colorParts[2]));
                    break;
                }
                case 4: {
                    color = new Color(Integer.parseInt(colorParts[0]), Integer.parseInt(colorParts[1]), Integer.parseInt(colorParts[2]), Integer.parseInt(colorParts[3]));
                    break;
                }
                default: {
                    throw new GeoPackageException("Unexpected color arguments: " + colorParts.length + ", color: " + colorString);
                }
            }
        }
        catch (Exception e) {
            throw new GeoPackageException("Invalid color: " + colorString + ", Allowable Formats: colorName | r,g,b | r,g,b,a", (Throwable)e);
        }
        return color;
    }

    public static void generate() {
        featureGeoPackage = GeoPackageManager.open(featureGeoPackageFile);
        if (featureGeoPackageFile.equals(tileGeoPackageFile)) {
            tileGeoPackage = featureGeoPackage;
        } else {
            if (!tileGeoPackageFile.exists()) {
                GeoPackageManager.create(tileGeoPackageFile);
            }
            tileGeoPackage = GeoPackageManager.open(tileGeoPackageFile);
        }
        FeatureDao featureDao = featureGeoPackage.getFeatureDao(featureTable);
        FeatureIndexManager indexManager = new FeatureIndexManager(featureGeoPackage, featureDao, geodesic);
        if (!indexManager.isIndexed()) {
            int numFeatures = featureDao.count();
            LOGGER.log(Level.INFO, "Indexing GeoPackage '" + featureGeoPackage.getName() + "' feature table '" + featureTable + "' with " + numFeatures + " features");
            ZoomLevelProgress indexProgress = new ZoomLevelProgress("Feature Indexer", "features", 1000, 10);
            indexProgress.setMax(numFeatures);
            indexManager.setProgress(indexProgress);
            int indexed = indexManager.index();
            LOGGER.log(Level.INFO, "Indexed GeoPackage '" + featureGeoPackage.getName() + "' feature table '" + featureTable + "', " + indexed + " features");
        }
        indexManager.close();
        DefaultFeatureTiles featureTiles = new DefaultFeatureTiles(featureGeoPackage, featureDao, geodesic);
        if (ignoreGeoPackageStyles) {
            featureTiles.ignoreFeatureTableStyles();
        }
        if (maxFeaturesPerTile != null) {
            featureTiles.setMaxFeaturesPerTile(maxFeaturesPerTile);
            featureTiles.setMaxFeaturesTileDraw(new NumberFeaturesTile());
        }
        if (tileWidth != null) {
            featureTiles.setTileWidth(tileWidth);
        }
        if (tileHeight != null) {
            featureTiles.setTileHeight(tileHeight);
        }
        if (tileScale != null) {
            featureTiles.setScale(tileScale.floatValue());
        }
        if (pointRadius != null) {
            featureTiles.setPointRadius(pointRadius.floatValue());
        }
        if (pointColor != null) {
            featureTiles.setPointColor(pointColor);
        }
        if (icon != null) {
            featureTiles.setPointIcon(icon);
        }
        if (lineStrokeWidth != null) {
            featureTiles.setLineStrokeWidth(lineStrokeWidth.floatValue());
        }
        if (lineColor != null) {
            featureTiles.setLineColor(lineColor);
        }
        if (polygonStrokeWidth != null) {
            featureTiles.setPolygonStrokeWidth(polygonStrokeWidth.floatValue());
        }
        if (polygonColor != null) {
            featureTiles.setPolygonColor(polygonColor);
        }
        if (fillPolygon != null) {
            featureTiles.setFillPolygon(fillPolygon);
        }
        if (polygonFillColor != null) {
            featureTiles.setPolygonFillColor(polygonFillColor);
        }
        featureTiles.setSimplifyGeometries(simplifyGeometries);
        featureTiles.calculateDrawOverlap();
        if (epsg == null) {
            epsg = 4326L;
        }
        BoundingBox webMercatorBoundingBox = null;
        Projection webMercatorProjection = ProjectionFactory.getProjection((long)3857L);
        Projection projection = null;
        if (boundingBox != null) {
            projection = ProjectionFactory.getProjection((long)epsg);
            if (projection.isUnit(Units.DEGREES)) {
                boundingBox = TileBoundingBoxUtils.boundDegreesBoundingBoxWithWebMercatorLimits((BoundingBox)boundingBox);
            }
            GeometryTransform transform = GeometryTransform.create((Projection)projection, (Projection)webMercatorProjection);
            webMercatorBoundingBox = boundingBox.transform(transform);
        } else {
            projection = ProjectionFactory.getProjection((long)4326L);
        }
        FeatureTileGenerator tileGenerator = new FeatureTileGenerator(tileGeoPackage, tileTable, (FeatureTiles)featureTiles, featureGeoPackage, webMercatorBoundingBox, webMercatorProjection);
        for (long zoomLevel : zoomLevels) {
            tileGenerator.addZoomLevel((int)zoomLevel);
        }
        if (compressFormat != null) {
            tileGenerator.setCompressFormat(compressFormat);
            if (compressQuality != null) {
                tileGenerator.setCompressQuality(compressQuality);
            }
        }
        if (xyzTiles) {
            tileGenerator.setXYZTiles(true);
        }
        int count = tileGenerator.getTileCount();
        System.out.println();
        System.out.println("Feature GeoPackage: " + featureGeoPackage.getName());
        System.out.println("Feature Table: " + featureTable);
        System.out.println("Tile GeoPackage: " + tileGeoPackage.getName());
        System.out.println("Tile Table: " + tileTable);
        System.out.println("Zoom Levels: " + zoomLevels);
        if (maxFeaturesPerTile != null) {
            System.out.println("Max Features Per Tile: " + maxFeaturesPerTile);
        }
        if (compressFormat != null) {
            System.out.println("Compress Format: " + compressFormat);
        }
        if (compressQuality != null) {
            System.out.println("Compress Quality: " + compressQuality);
        }
        if (xyzTiles) {
            System.out.println("Save as XYZ Tiles: true");
        }
        if (boundingBox != null) {
            System.out.println("Bounding Box:");
            System.out.println("\tMin Lon: " + boundingBox.getMinLongitude());
            System.out.println("\tMin Lat: " + boundingBox.getMinLatitude());
            System.out.println("\tMax Lon: " + boundingBox.getMaxLongitude());
            System.out.println("\tMax Lat: " + boundingBox.getMaxLatitude());
        }
        if (epsg != null) {
            System.out.println("EPSG: " + epsg);
        }
        System.out.println("Log Count Frequency: " + progress.getCountFrequency() + " tiles");
        System.out.println("Log Time Frequency: " + progress.getTimeFrequency() + " seconds");
        System.out.println("Expected Tile Count: " + count);
        System.out.println();
        StringBuilder tileStyle = new StringBuilder();
        if (tileWidth != null) {
            tileStyle.append(", Width: ").append(tileWidth);
        }
        if (tileHeight != null) {
            tileStyle.append(", Height: ").append(tileHeight);
        }
        if (pointRadius != null) {
            tileStyle.append(", Point Radius: ").append(pointRadius);
        }
        if (pointColor != null) {
            tileStyle.append(", Point Color: ").append(FeatureTileGen.colorString(pointColor));
        }
        if (icon != null) {
            tileStyle.append(", Point Icon (height=").append(icon.getHeight()).append(", width=").append(icon.getWidth()).append(", xoffset=").append(icon.getXOffset()).append(", yoffset=").append(icon.getYOffset()).append(")");
        }
        if (lineStrokeWidth != null) {
            tileStyle.append(", Line Stroke Width: ").append(lineStrokeWidth);
        }
        if (lineColor != null) {
            tileStyle.append(", Line Color: ").append(FeatureTileGen.colorString(lineColor));
        }
        if (polygonStrokeWidth != null) {
            tileStyle.append(", Polygon Stroke Width: ").append(polygonStrokeWidth);
        }
        if (polygonColor != null) {
            tileStyle.append(", Polygon Color: ").append(FeatureTileGen.colorString(polygonColor));
        }
        if (fillPolygon != null && fillPolygon.booleanValue()) {
            tileStyle.append(", Fill Polygon");
        }
        if (polygonFillColor != null) {
            tileStyle.append(", Polygon Fill Color: ").append(FeatureTileGen.colorString(polygonFillColor));
        }
        if (simplifyGeometries) {
            tileStyle.append(", Simplify Geometries");
        }
        if (geodesic) {
            tileStyle.append(", Geodesic");
        }
        if (tileStyle.length() == 0) {
            tileStyle.append(", Default Settings");
        }
        LOGGER.log(Level.INFO, "Tile Attributes" + tileStyle);
        tileGenerator.setProgress(progress);
        LOGGER.log(Level.INFO, "Generating Tiles...");
        try {
            tileGenerator.generateTiles();
        }
        catch (IOException | SQLException e) {
            throw new GeoPackageException("Exception while generating tiles", (Throwable)e);
        }
        FeatureTileGen.finish();
    }

    private static void finish() {
        if (progress.getMax() != null) {
            StringBuilder output = new StringBuilder();
            output.append("\nTile Generation: ").append(progress.getProgress()).append(" of ").append(progress.getMax());
            if (tileGeoPackage != null) {
                try {
                    GeoPackageTextOutput textOutput = new GeoPackageTextOutput(tileGeoPackage);
                    output.append("\n\n");
                    output.append(textOutput.header());
                    output.append("\n\n");
                    output.append(textOutput.tileTable(tileTable));
                }
                finally {
                    tileGeoPackage.close();
                }
            }
            if (featureGeoPackage != null) {
                featureGeoPackage.close();
            }
            System.out.println(output.toString());
        }
    }

    private static void printUsage() {
        DefaultFeatureTiles featureTiles = new DefaultFeatureTiles(null);
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-m max_features_per_tile] [-f compress_format] [-q compress_quality] [-xyz] [-bbox minLon,minLat,maxLon,maxLat] [-epsg epsg] [-tileWidth width] [-tileHeight height] [-tileScale scale] [-pointRadius radius] [-pointColor color] [-pointIcon image_file] [-iconWidth width] [-iconHeight height] [-centerIcon] [-lineStrokeWidth stroke_width] [-lineColor color] [-polygonStrokeWidth stroke_width] [-polygonColor color] [-fillPolygon] [-polygonFillColor color] [-simplifyGeometries true|false] [-geodesic true|false] [-ignoreGeoPackageStyles true|false] [-logCount count] [-logTime time] feature_geopackage_file feature_table tile_geopackage_file tile_table zoom_levels");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tGenerates tiles from a GeoPackage feature table into a tile table");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t-m max_features_per_tile");
        System.out.println("\t\tMax features to generate into a tile before generating a numbered feature count tile (default is 5000, use -1 for no max)");
        System.out.println();
        System.out.println("\t-f compress_format");
        System.out.println("\t\tTile compression image format: png, jpg, jpeg (default is no compression, native format)");
        System.out.println();
        System.out.println("\t-q compress_quality");
        System.out.println("\t\tTile compression image quality between 0.0 and 1.0 (not valid for png, default is 1.0)");
        System.out.println();
        System.out.println("\t-xyz");
        System.out.println("\t\tGenerate tiles in XYZ tile format (default is GeoPackage format with minimum bounds)");
        System.out.println();
        System.out.println("\t-bbox minLon,minLat,maxLon,maxLat");
        System.out.println("\t\tOnly tiles overlapping the bounding box are requested (default is the world)");
        System.out.println();
        System.out.println("\t-epsg epsg");
        System.out.println("\t\tEPSG number of the provided bounding box (default is 4326, WGS 84)");
        System.out.println();
        System.out.println("\t-tileWidth width");
        System.out.println("\t\tWidth used when creating each tile (default is " + featureTiles.getTileWidth() + ")");
        System.out.println();
        System.out.println("\t-tileHeight height");
        System.out.println("\t\tHeight used when creating each tile (default is " + featureTiles.getTileHeight() + ")");
        System.out.println();
        System.out.println("\t-tileScale scale");
        System.out.println("\t\tScale factor used when creating each tile (default is " + featureTiles.getScale() + ")");
        System.out.println();
        System.out.println("\t-pointRadius radius");
        System.out.println("\t\tFloating point circle radius used when drawing points (default is " + featureTiles.getPointRadius() + ")");
        System.out.println();
        System.out.println("\t-pointColor color");
        System.out.println("\t\tColor used when drawing points formatted as one of: [ name | r,g,b | r,g,b,a ] (default is " + FeatureTileGen.colorString(featureTiles.getPointColor()) + ")");
        System.out.println();
        System.out.println("\t-pointIcon image_file");
        System.out.println("\t\tImage file containing image to use when drawing points in place of a drawn circle");
        System.out.println();
        System.out.println("\t-iconWidth width");
        System.out.println("\t\tPoint icon display width (default is actual icon width)");
        System.out.println();
        System.out.println("\t-iconHeight height");
        System.out.println("\t\tPoint icon display height (default is actual icon height)");
        System.out.println();
        System.out.println("\t-centerIcon");
        System.out.println("\t\tDraw point icons by centering the icon image to the location (default is pinning to bottom center)");
        System.out.println();
        System.out.println("\t-lineStrokeWidth stroke_width");
        System.out.println("\t\tFloating point stroke width when drawing lines (default is " + featureTiles.getLineStrokeWidth() + ")");
        System.out.println();
        System.out.println("\t-lineColor color");
        System.out.println("\t\tColor used when drawing lines formatted as one of: [ name | r,g,b | r,g,b,a ] (default is " + FeatureTileGen.colorString(featureTiles.getLineColor()) + ")");
        System.out.println();
        System.out.println("\t-polygonStrokeWidth stroke_width");
        System.out.println("\t\tFloating point stroke width when drawing polygons (default is " + featureTiles.getPolygonStrokeWidth() + ")");
        System.out.println();
        System.out.println("\t-polygonColor color");
        System.out.println("\t\tColor used when drawing polygons formatted as one of: [ name | r,g,b | r,g,b,a ] (default is " + FeatureTileGen.colorString(featureTiles.getPolygonColor()) + ")");
        System.out.println();
        System.out.println("\t-fillPolygon");
        System.out.println("\t\tFill polygons with color (default is " + featureTiles.isFillPolygon() + ")");
        System.out.println();
        System.out.println("\t-polygonFillColor color");
        System.out.println("\t\tColor used when filling polygons formatted as one of: [ name | r,g,b | r,g,b,a ] (default is " + FeatureTileGen.colorString(featureTiles.getPolygonFillColor()) + ")");
        System.out.println();
        System.out.println("\t-simplifyGeometries true|false");
        System.out.println("\t\tFlag indicating whether geometries should be simplified with a similar curve with fewer points before drawn (default is true)");
        System.out.println();
        System.out.println("\t-geodesic true|false");
        System.out.println("\t\tFlag indicating whether geometries should be drawn as geodesic lines (default is false)");
        System.out.println();
        System.out.println("\t-ignoreGeoPackageStyles true|false");
        System.out.println("\t\tFlag indicating whether styles saved within the GeoPackage should be ignored (default is false)");
        System.out.println();
        System.out.println("\t-logCount count");
        System.out.println("\t\tLog frequency count of generated tiles (default is 1000)");
        System.out.println();
        System.out.println("\t-logTime time");
        System.out.println("\t\tLog frequency time in seconds (default is 60)");
        System.out.println();
        System.out.println("\tfeature_geopackage_file");
        System.out.println("\t\tpath to the GeoPackage file containing the feature table to generate tiles from");
        System.out.println();
        System.out.println("\tfeature_table");
        System.out.println("\t\tfeature table name within the GeoPackage file to generate tiles from");
        System.out.println();
        System.out.println("\ttile_geopackage_file");
        System.out.println("\t\tpath to the GeoPackage file to create with tiles, or existing file to update");
        System.out.println();
        System.out.println("\ttile_table");
        System.out.println("\t\ttile table name within the GeoPackage file to create or update");
        System.out.println();
        System.out.println("\tzoom_levels");
        System.out.println("\t\tZoom levels to request tiles for, specified as 'z', 'zmin-zmax', 'z1,z2,...', or 'zmin zmax'");
        System.out.println();
    }

    private static String colorString(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha();
    }
}

