/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.sis.util.stream.BaseStreamWrapper;

public abstract class StreamWrapper<T>
extends BaseStreamWrapper<T, Stream<T>>
implements Stream<T> {
    Stream<T> source;

    StreamWrapper() {
    }

    protected StreamWrapper(Stream<T> source) {
        super(source);
        this.source = source;
    }

    @Override
    protected final Stream<T> source() {
        if (this.source != null) {
            return this.source;
        }
        throw this.inactive();
    }

    protected final Stream<T> delegate() {
        BaseStream s = this.source();
        this.source = null;
        return s;
    }

    private Stream<T> update(Stream<T> result) {
        if (this.source == null) {
            return result;
        }
        this.source = result;
        return this;
    }

    @Override
    public Stream<T> parallel() {
        return this.update((Stream)this.source().parallel());
    }

    @Override
    public Stream<T> sequential() {
        return this.update((Stream)this.source().sequential());
    }

    @Override
    public Stream<T> unordered() {
        return this.update((Stream)this.source().unordered());
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.update(this.source().filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return this.delegate().map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.delegate().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.delegate().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.delegate().mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.delegate().flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.delegate().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.delegate().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.delegate().flatMapToDouble(mapper);
    }

    @Override
    public Stream<T> distinct() {
        return this.update(this.source().distinct());
    }

    @Override
    public Stream<T> sorted() {
        return this.update(this.source().sorted());
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.update(this.source().sorted(comparator));
    }

    @Override
    public Stream<T> peek(Consumer<? super T> action) {
        return this.update(this.source().peek(action));
    }

    @Override
    public Stream<T> limit(long maxSize) {
        return this.update(this.source().limit(maxSize));
    }

    @Override
    public Stream<T> skip(long n) {
        return this.update(this.source().skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.source().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.source().forEachOrdered(action);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.source().reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.source().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.source().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.source().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.source().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.source().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.source().max(comparator);
    }

    @Override
    public long count() {
        return this.source().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.source().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.source().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.source().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.source().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.source().findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.source().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.source().spliterator();
    }

    @Override
    public Object[] toArray() {
        return this.source().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.source().toArray(generator);
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return this.update((Stream)this.source().onClose(closeHandler));
    }
}

