/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Optional;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.metadata.sql.util.SQLUtilities;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.util.Localized;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class Column {
    public final String name;
    public final String label;
    String propertyName;
    public final int type;
    public final String typeName;
    private final int precision;
    public final boolean isNullable;
    private GeometryType geometryType;
    private CoordinateReferenceSystem defaultCRS;
    ValueGetter<?> valueGetter;

    Column(int type, String typeName) {
        this.propertyName = "element";
        this.label = "element";
        this.name = "element";
        this.type = type;
        this.typeName = typeName;
        this.precision = 0;
        this.isNullable = false;
    }

    Column(Analyzer analyzer, ResultSet metadata, String quote) throws SQLException {
        this.label = this.name = analyzer.getUniqueString(metadata, "COLUMN_NAME");
        this.type = metadata.getInt("DATA_TYPE");
        this.typeName = Column.localPart(metadata.getString("TYPE_NAME"), quote);
        this.precision = metadata.getInt("COLUMN_SIZE");
        this.isNullable = Boolean.TRUE.equals(SQLUtilities.parseBoolean((String)metadata.getString("IS_NULLABLE")));
        this.propertyName = this.label;
    }

    Column(ResultSetMetaData metadata, int column, String quote) throws SQLException {
        this.name = metadata.getColumnName(column);
        this.label = metadata.getColumnLabel(column);
        this.type = metadata.getColumnType(column);
        this.typeName = Column.localPart(metadata.getColumnTypeName(column), quote);
        this.precision = metadata.getPrecision(column);
        this.isNullable = metadata.isNullable(column) == 1;
        this.propertyName = this.label;
    }

    private static String localPart(String type, String quote) throws SQLDataException {
        int start;
        int end;
        if (type == null) {
            throw new SQLDataException(Errors.format((short)90, (Object)"TYPE_NAME"));
        }
        if (quote != null && (end = type.lastIndexOf(quote)) >= 0 && (start = type.lastIndexOf(quote, end - 1)) >= 0 && end > (start += quote.length())) {
            type = type.substring(start, end);
        }
        return type;
    }

    final void makeSpatial(Localized caller, GeometryType type, CoordinateReferenceSystem crs) throws DataStoreContentException {
        String property;
        if (this.geometryType != null && !this.geometryType.equals((Object)type)) {
            property = "geometryType";
        } else if (this.defaultCRS != null && !this.defaultCRS.equals(crs)) {
            property = "defaultCRS";
        } else {
            this.geometryType = type;
            this.defaultCRS = crs;
            return;
        }
        throw new DataStoreContentException(Errors.getResources((Locale)caller.getLocale()).getString((short)164, (Object)property));
    }

    public final Optional<GeometryType> getGeometryType() {
        return Optional.ofNullable(this.geometryType);
    }

    public final Optional<CoordinateReferenceSystem> getDefaultCRS() {
        return Optional.ofNullable(this.defaultCRS);
    }

    final AttributeTypeBuilder<?> createAttribute(FeatureTypeBuilder feature) {
        Class valueType = this.valueGetter.valueType;
        boolean isArray = this.valueGetter instanceof ValueGetter.AsArray;
        if (isArray) {
            valueType = ((ValueGetter.AsArray)this.valueGetter).cmget.valueType;
        }
        AttributeTypeBuilder attribute = feature.addAttribute(valueType).setName((CharSequence)this.propertyName);
        if (this.precision > 0 && this.precision != Integer.MAX_VALUE && CharSequence.class.isAssignableFrom(valueType)) {
            attribute.setMaximalLength(Integer.valueOf(this.precision));
        }
        if (isArray) {
            attribute.setMinimumOccurs(0);
            attribute.setMaximumOccurs(Integer.MAX_VALUE);
        } else if (this.isNullable) {
            attribute.setMinimumOccurs(0);
        }
        if (this.geometryType != null || this.defaultCRS != null) {
            attribute.setCRS(this.defaultCRS);
        }
        return attribute;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"name", this.name, "propertyName", this.propertyName, "type", this.type, "typeName", this.typeName, "geometryType", this.geometryType, "precision", this.precision, "isNullable", this.isNullable});
    }
}

