/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.jul.LevelConverter;
import org.apache.logging.log4j.jul.LevelTranslator;

public class DefaultLevelConverter
implements LevelConverter {
    private final ConcurrentMap<java.util.logging.Level, Level> julToLog4j = new ConcurrentHashMap<java.util.logging.Level, Level>(9);
    private final Map<Level, java.util.logging.Level> log4jToJul = new IdentityHashMap<Level, java.util.logging.Level>(10);
    private final List<java.util.logging.Level> sortedJulLevels = new ArrayList<java.util.logging.Level>(9);

    public DefaultLevelConverter() {
        this.mapJulToLog4j(java.util.logging.Level.ALL, Level.ALL);
        this.mapJulToLog4j(java.util.logging.Level.FINEST, LevelTranslator.FINEST);
        this.mapJulToLog4j(java.util.logging.Level.FINER, Level.TRACE);
        this.mapJulToLog4j(java.util.logging.Level.FINE, Level.DEBUG);
        this.mapJulToLog4j(java.util.logging.Level.CONFIG, LevelTranslator.CONFIG);
        this.mapJulToLog4j(java.util.logging.Level.INFO, Level.INFO);
        this.mapJulToLog4j(java.util.logging.Level.WARNING, Level.WARN);
        this.mapJulToLog4j(java.util.logging.Level.SEVERE, Level.ERROR);
        this.mapJulToLog4j(java.util.logging.Level.OFF, Level.OFF);
        this.mapLog4jToJul(Level.ALL, java.util.logging.Level.ALL);
        this.mapLog4jToJul(LevelTranslator.FINEST, java.util.logging.Level.FINEST);
        this.mapLog4jToJul(Level.TRACE, java.util.logging.Level.FINER);
        this.mapLog4jToJul(Level.DEBUG, java.util.logging.Level.FINE);
        this.mapLog4jToJul(LevelTranslator.CONFIG, java.util.logging.Level.CONFIG);
        this.mapLog4jToJul(Level.INFO, java.util.logging.Level.INFO);
        this.mapLog4jToJul(Level.WARN, java.util.logging.Level.WARNING);
        this.mapLog4jToJul(Level.ERROR, java.util.logging.Level.SEVERE);
        this.mapLog4jToJul(Level.FATAL, java.util.logging.Level.SEVERE);
        this.mapLog4jToJul(Level.OFF, java.util.logging.Level.OFF);
        this.sortedJulLevels.addAll(this.julToLog4j.keySet());
        Collections.sort(this.sortedJulLevels, new JulLevelComparator());
    }

    private long distance(java.util.logging.Level javaLevel, java.util.logging.Level customJavaLevel) {
        return Math.abs((long)customJavaLevel.intValue() - (long)javaLevel.intValue());
    }

    private void mapJulToLog4j(java.util.logging.Level julLevel, Level level) {
        this.julToLog4j.put(julLevel, level);
    }

    private void mapLog4jToJul(Level level, java.util.logging.Level julLevel) {
        this.log4jToJul.put(level, julLevel);
    }

    private Level nearestLevel(java.util.logging.Level customJavaLevel) {
        long prevDist = Long.MAX_VALUE;
        java.util.logging.Level prevLevel = null;
        for (java.util.logging.Level mappedJavaLevel : this.sortedJulLevels) {
            long distance = this.distance(customJavaLevel, mappedJavaLevel);
            if (distance > prevDist) {
                return (Level)this.julToLog4j.get(prevLevel);
            }
            prevDist = distance;
            prevLevel = mappedJavaLevel;
        }
        return (Level)this.julToLog4j.get(prevLevel);
    }

    @Override
    public java.util.logging.Level toJavaLevel(Level level) {
        return this.log4jToJul.get(level);
    }

    @Override
    public Level toLevel(java.util.logging.Level javaLevel) {
        if (javaLevel == null) {
            return null;
        }
        Level level = (Level)this.julToLog4j.get(javaLevel);
        if (level != null) {
            return level;
        }
        Level nearestLevel = this.nearestLevel(javaLevel);
        this.julToLog4j.put(javaLevel, nearestLevel);
        return nearestLevel;
    }

    static final class JulLevelComparator
    implements Comparator<java.util.logging.Level> {
        JulLevelComparator() {
        }

        @Override
        public int compare(java.util.logging.Level level1, java.util.logging.Level level2) {
            return Integer.compare(level1.intValue(), level2.intValue());
        }
    }
}

