/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.reactor3;

import com.linecorp.armeria.common.ContextHolder;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ParallelFlux;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public final class RequestContextHooks {
    private static final Logger logger = LoggerFactory.getLogger(RequestContextHooks.class);
    private static final String ON_EACH_OPERATOR_HOOK_KEY = RequestContextHooks.class.getName() + "#ON_EACH_OPERATOR_HOOK_KEY";
    private static final String ON_LAST_OPERATOR_HOOK_KEY = RequestContextHooks.class.getName() + "#ON_LAST_OPERATOR_HOOK_KEY";
    private static final String ON_SCHEDULER_HOOK_KEY = RequestContextHooks.class.getName() + "#ON_SCHEDULER_HOOK_KEY";
    private static boolean warnedParallelFluxUnsupported;
    private static boolean enabled;
    private static final String FLUX_ERROR_SUPPLIED;
    private static final String MONO_ERROR_SUPPLIED;

    public static synchronized void enable() {
        if (enabled) {
            return;
        }
        Hooks.onEachOperator((String)ON_EACH_OPERATOR_HOOK_KEY, source -> {
            Object parent;
            if (source instanceof ContextHolder || RequestContextHooks.isReproducibleScalarType((Publisher<Object>)source)) {
                return source;
            }
            if (source instanceof Scannable && (parent = ((Scannable)source).scanUnsafe(Scannable.Attr.PARENT)) instanceof ContextHolder) {
                return RequestContextHooks.makeContextAware((Publisher<Object>)source, ((ContextHolder)parent).context());
            }
            return (Publisher)RequestContext.mapCurrent(requestContext -> RequestContextHooks.makeContextAware((Publisher<Object>)source, requestContext), () -> source);
        });
        Hooks.onLastOperator((String)ON_LAST_OPERATOR_HOOK_KEY, source -> {
            Object parent;
            if (source instanceof ContextHolder || RequestContextHooks.isReproducibleScalarType((Publisher<Object>)source)) {
                return source;
            }
            if (source instanceof Scannable && (parent = ((Scannable)source).scanUnsafe(Scannable.Attr.PARENT)) instanceof ContextHolder) {
                return RequestContextHooks.makeContextAware((Publisher<Object>)source, ((ContextHolder)parent).context());
            }
            return source;
        });
        Schedulers.onScheduleHook((String)ON_SCHEDULER_HOOK_KEY, task -> (Runnable)RequestContext.mapCurrent(requestContext -> requestContext.makeContextAware(task), () -> task));
        enabled = true;
    }

    public static synchronized void disable() {
        if (!enabled) {
            return;
        }
        Hooks.resetOnEachOperator((String)ON_EACH_OPERATOR_HOOK_KEY);
        Hooks.resetOnLastOperator((String)ON_LAST_OPERATOR_HOOK_KEY);
        Schedulers.resetOnScheduleHook((String)ON_SCHEDULER_HOOK_KEY);
        enabled = false;
    }

    private static boolean isReproducibleScalarType(Publisher<Object> publisher) {
        if (publisher instanceof Fuseable.ScalarCallable) {
            String className = publisher.getClass().getName();
            return !className.equals(FLUX_ERROR_SUPPLIED) && !className.equals(MONO_ERROR_SUPPLIED);
        }
        return false;
    }

    private static Publisher<Object> makeContextAware(Publisher<Object> source, RequestContext ctx) {
        if (source instanceof Mono) {
            return new ContextAwareMono((Mono<Object>)((Mono)source), ctx);
        }
        if (source instanceof ConnectableFlux) {
            return new ContextAwareConnectableFlux((ConnectableFlux<Object>)((ConnectableFlux)source), ctx);
        }
        if (source instanceof ParallelFlux) {
            if (!warnedParallelFluxUnsupported) {
                warnedParallelFluxUnsupported = true;
                logger.warn("Hooks for {} are not supported yet.", (Object)ParallelFlux.class.getSimpleName());
            }
            return source;
        }
        if (source instanceof Flux) {
            return new ContextAwareFlux((Flux<Object>)((Flux)source), ctx);
        }
        return source;
    }

    private RequestContextHooks() {
    }

    static {
        FLUX_ERROR_SUPPLIED = Flux.class.getPackage().getName() + ".FluxErrorSupplied";
        MONO_ERROR_SUPPLIED = Mono.class.getPackage().getName() + ".MonoErrorSupplied";
    }

    @VisibleForTesting
    static final class ContextAwareMono
    extends Mono<Object>
    implements ContextHolder {
        private final Mono<Object> source;
        private final RequestContext ctx;

        ContextAwareMono(Mono<Object> source, RequestContext ctx) {
            this.source = source;
            this.ctx = ctx;
        }

        public RequestContext context() {
            return this.ctx;
        }

        public void subscribe(CoreSubscriber<? super Object> subscriber) {
            try (SafeCloseable ignored = this.ctx.push();){
                if (subscriber instanceof ContextAwareCoreSubscriber) {
                    this.source.subscribe(subscriber);
                } else {
                    this.source.subscribe((CoreSubscriber)new ContextAwareCoreSubscriber(subscriber, this.ctx));
                }
            }
        }
    }

    private static final class ContextAwareConnectableFlux
    extends ConnectableFlux<Object>
    implements ContextHolder {
        private final ConnectableFlux<Object> source;
        private final RequestContext ctx;

        ContextAwareConnectableFlux(ConnectableFlux<Object> source, RequestContext ctx) {
            this.source = source;
            this.ctx = ctx;
        }

        public RequestContext context() {
            return this.ctx;
        }

        public void connect(Consumer<? super Disposable> cancelSupport) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.source.connect(cancelSupport);
            }
        }

        public void subscribe(CoreSubscriber<? super Object> subscriber) {
            try (SafeCloseable ignored = this.ctx.push();){
                if (subscriber instanceof ContextAwareCoreSubscriber) {
                    this.source.subscribe(subscriber);
                } else {
                    this.source.subscribe((CoreSubscriber)new ContextAwareCoreSubscriber(subscriber, this.ctx));
                }
            }
        }
    }

    @VisibleForTesting
    static final class ContextAwareFlux
    extends Flux<Object>
    implements ContextHolder {
        private final Flux<Object> source;
        private final RequestContext ctx;

        ContextAwareFlux(Flux<Object> source, RequestContext ctx) {
            this.source = source;
            this.ctx = ctx;
        }

        public RequestContext context() {
            return this.ctx;
        }

        public void subscribe(CoreSubscriber<? super Object> subscriber) {
            try (SafeCloseable ignored = this.ctx.push();){
                if (subscriber instanceof ContextAwareCoreSubscriber) {
                    this.source.subscribe(subscriber);
                } else {
                    this.source.subscribe((CoreSubscriber)new ContextAwareCoreSubscriber(subscriber, this.ctx));
                }
            }
        }
    }

    private static final class ContextAwareCoreSubscriber
    implements CoreSubscriber<Object> {
        private final CoreSubscriber<? super Object> subscriber;
        private final RequestContext ctx;

        ContextAwareCoreSubscriber(CoreSubscriber<? super Object> subscriber, RequestContext ctx) {
            this.subscriber = subscriber;
            this.ctx = ctx;
        }

        public Context currentContext() {
            return this.subscriber.currentContext();
        }

        public void onSubscribe(Subscription s) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.subscriber.onSubscribe(s);
            }
        }

        public void onNext(Object o) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.subscriber.onNext(o);
            }
        }

        public void onError(Throwable t) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.subscriber.onError(t);
            }
        }

        public void onComplete() {
            try (SafeCloseable ignored = this.ctx.push();){
                this.subscriber.onComplete();
            }
        }
    }
}

