/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RedirectService
implements HttpService {
    private static final Pattern VALID_DEFAULT_URI_PATTERN = Pattern.compile("(?:(?:^https?:/{2}(?:([^:]+:)?[^:@]+@)?[^:]+)(?::[0-9]{1,5})?)?(?:/[^/{}:]+|/:[^/{}]+|/\\{[^/{}]+})+/?");
    private static final Pattern PATTERN_PARAMS_START = Pattern.compile("/:|/\\{");
    private final HttpStatus httpStatus;
    private final Function<? super ServiceRequestContext, String> locationFunction;
    private final boolean preserveQueryString;
    @Nullable
    private Set<String> paramNames;

    public RedirectService(String locationPattern) {
        this(locationPattern, true);
    }

    public RedirectService(String locationPattern, boolean preserveQueryString) {
        this(HttpStatus.TEMPORARY_REDIRECT, locationPattern, preserveQueryString);
    }

    public RedirectService(Function<? super ServiceRequestContext, String> locationFunction) {
        this(locationFunction, true);
    }

    public RedirectService(Function<? super ServiceRequestContext, String> locationFunction, boolean preserveQueryString) {
        this(HttpStatus.TEMPORARY_REDIRECT, locationFunction, preserveQueryString);
    }

    public RedirectService(HttpStatus redirectStatus, String locationPattern) {
        this(redirectStatus, locationPattern, true);
    }

    public RedirectService(HttpStatus redirectStatus, String locationPattern, boolean preserveQueryString) {
        this(redirectStatus, RedirectService.toLocationFunction(locationPattern), preserveQueryString);
        Matcher m = PATTERN_PARAMS_START.matcher(locationPattern);
        if (m.find()) {
            this.paramNames = Route.builder().path(locationPattern.substring(m.start())).build().paramNames();
        }
    }

    public RedirectService(HttpStatus redirectStatus, Function<? super ServiceRequestContext, String> locationFunction) {
        this(redirectStatus, locationFunction, true);
    }

    public RedirectService(HttpStatus redirectStatus, Function<? super ServiceRequestContext, String> locationFunction, boolean preserveQueryString) {
        Objects.requireNonNull(redirectStatus, "redirectStatus");
        Objects.requireNonNull(locationFunction, "locationFunction");
        if (redirectStatus.compareTo(HttpStatus.MULTIPLE_CHOICES) < 0 || redirectStatus.compareTo(HttpStatus.TEMPORARY_REDIRECT) > 0) {
            throw new IllegalArgumentException("redirectStatus: " + redirectStatus + " (expected: 300 .. 307)");
        }
        this.httpStatus = redirectStatus;
        this.locationFunction = locationFunction;
        this.preserveQueryString = preserveQueryString;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        String location = this.locationFunction.apply(ctx);
        Objects.requireNonNull(location, "locationFunction returned null.");
        if (this.preserveQueryString) {
            location = RedirectService.appendQueryString(ctx, location);
        }
        return HttpResponse.of(ResponseHeaders.of(this.httpStatus, (CharSequence)HttpHeaderNames.LOCATION, location));
    }

    private static String appendQueryString(ServiceRequestContext ctx, String location) {
        String query = ctx.query();
        if (query == null || location.lastIndexOf(63) >= 0) {
            return location;
        }
        return location + '?' + query;
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        if (this.paramNames != null) {
            Set<String> params = cfg.route().paramNames();
            for (String param : this.paramNames) {
                if (params.contains(param)) continue;
                throw new IllegalArgumentException("pathParams: " + param + " (no matching param in " + params + ')');
            }
            this.paramNames = null;
        }
        HttpService.super.serviceAdded(cfg);
    }

    private static Function<? super ServiceRequestContext, String> toLocationFunction(String locationPattern) {
        Objects.requireNonNull(locationPattern, "locationPattern");
        if (!RedirectService.isDefaultUriPattern(locationPattern)) {
            throw new IllegalArgumentException("locationPattern: " + locationPattern);
        }
        return ctx -> RedirectService.populatePatternParams(locationPattern, ctx.pathParams());
    }

    private static String populatePatternParams(String pathPattern, Map<String, String> pathParams) {
        for (Map.Entry<String, String> e : pathParams.entrySet()) {
            String tokenPattern = "\\{" + e.getKey() + "\\}|:" + e.getKey();
            pathPattern = pathPattern.replaceAll(tokenPattern, e.getValue());
        }
        return pathPattern;
    }

    private static boolean isDefaultUriPattern(String pathPattern) {
        return VALID_DEFAULT_URI_PATTERN.matcher(pathPattern).matches();
    }
}

