/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.Http1HeaderNaming;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.shaded.fastutil.ints.Int2ObjectMap;
import com.linecorp.armeria.internal.shaded.fastutil.ints.Int2ObjectOpenHashMap;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectArrayMap;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.ClientAddressSource;
import com.linecorp.armeria.server.ConnectionLimitingHandler;
import com.linecorp.armeria.server.DomainMappingBuilder;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ShutdownSupport;
import com.linecorp.armeria.server.VirtualHost;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Mapping;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

final class DefaultServerConfig
implements ServerConfig {
    @Nullable
    private Server server;
    private final List<ServerPort> ports;
    private final VirtualHost defaultVirtualHost;
    private final List<VirtualHost> virtualHosts;
    @Nullable
    private final Int2ObjectMap<Mapping<String, VirtualHost>> virtualHostAndPortMapping;
    private final List<ServiceConfig> services;
    private final EventLoopGroup workerGroup;
    private final boolean shutdownWorkerGroupOnStop;
    private final Executor startStopExecutor;
    private final int maxNumConnections;
    private final long idleTimeoutMillis;
    private final boolean keepAliveOnPing;
    private final long pingIntervalMillis;
    private final long maxConnectionAgeMillis;
    private final long connectionDrainDurationMicros;
    private final int maxNumRequestsPerConnection;
    private final int http2InitialConnectionWindowSize;
    private final int http2InitialStreamWindowSize;
    private final long http2MaxStreamsPerConnection;
    private final int http2MaxFrameSize;
    private final long http2MaxHeaderListSize;
    private final int http2MaxResetFramesPerWindow;
    private final int http2MaxResetFramesWindowSeconds;
    private final int http1MaxInitialLineLength;
    private final int http1MaxHeaderSize;
    private final int http1MaxChunkSize;
    private final Duration gracefulShutdownQuietPeriod;
    private final Duration gracefulShutdownTimeout;
    private final BlockingTaskExecutor blockingTaskExecutor;
    private final MeterRegistry meterRegistry;
    private final int proxyProtocolMaxTlvSize;
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final Map<ChannelOption<?>, ?> childChannelOptions;
    private final Consumer<? super ChannelPipeline> childChannelPipelineCustomizer;
    private final List<ClientAddressSource> clientAddressSources;
    private final Predicate<? super InetAddress> clientAddressTrustedProxyFilter;
    private final Predicate<? super InetAddress> clientAddressFilter;
    private final Function<? super ProxiedAddresses, ? extends InetSocketAddress> clientAddressMapper;
    private final boolean enableServerHeader;
    private final boolean enableDateHeader;
    private final ServerErrorHandler errorHandler;
    private final Http1HeaderNaming http1HeaderNaming;
    private final DependencyInjector dependencyInjector;
    private final Function<String, String> absoluteUriTransformer;
    private final long unhandledExceptionsReportIntervalMillis;
    private final List<ShutdownSupport> shutdownSupports;
    @Nullable
    private final Mapping<String, SslContext> sslContexts;
    @Nullable
    private String strVal;

    DefaultServerConfig(Iterable<ServerPort> ports, VirtualHost defaultVirtualHost, List<VirtualHost> virtualHosts, EventLoopGroup workerGroup, boolean shutdownWorkerGroupOnStop, Executor startStopExecutor, int maxNumConnections, long idleTimeoutMillis, boolean keepAliveOnPing, long pingIntervalMillis, long maxConnectionAgeMillis, int maxNumRequestsPerConnection, long connectionDrainDurationMicros, int http2InitialConnectionWindowSize, int http2InitialStreamWindowSize, long http2MaxStreamsPerConnection, int http2MaxFrameSize, long http2MaxHeaderListSize, int http2MaxResetFramesPerWindow, int http2MaxResetFramesWindowSeconds, int http1MaxInitialLineLength, int http1MaxHeaderSize, int http1MaxChunkSize, Duration gracefulShutdownQuietPeriod, Duration gracefulShutdownTimeout, BlockingTaskExecutor blockingTaskExecutor, MeterRegistry meterRegistry, int proxyProtocolMaxTlvSize, Map<ChannelOption<?>, Object> channelOptions, Map<ChannelOption<?>, Object> childChannelOptions, Consumer<? super ChannelPipeline> childChannelPipelineCustomizer, List<ClientAddressSource> clientAddressSources, Predicate<? super InetAddress> clientAddressTrustedProxyFilter, Predicate<? super InetAddress> clientAddressFilter, Function<? super ProxiedAddresses, ? extends InetSocketAddress> clientAddressMapper, boolean enableServerHeader, boolean enableDateHeader, ServerErrorHandler errorHandler, @Nullable Mapping<String, SslContext> sslContexts, Http1HeaderNaming http1HeaderNaming, DependencyInjector dependencyInjector, Function<? super String, String> absoluteUriTransformer, long unhandledExceptionsReportIntervalMillis, List<ShutdownSupport> shutdownSupports) {
        Objects.requireNonNull(ports, "ports");
        Objects.requireNonNull(defaultVirtualHost, "defaultVirtualHost");
        Objects.requireNonNull(virtualHosts, "virtualHosts");
        this.workerGroup = Objects.requireNonNull(workerGroup, "workerGroup");
        this.shutdownWorkerGroupOnStop = shutdownWorkerGroupOnStop;
        this.startStopExecutor = Objects.requireNonNull(startStopExecutor, "startStopExecutor");
        this.maxNumConnections = DefaultServerConfig.validateMaxNumConnections(maxNumConnections);
        this.idleTimeoutMillis = DefaultServerConfig.validateIdleTimeoutMillis(idleTimeoutMillis);
        this.keepAliveOnPing = keepAliveOnPing;
        this.pingIntervalMillis = DefaultServerConfig.validateNonNegative(pingIntervalMillis, "pingIntervalMillis");
        this.maxNumRequestsPerConnection = DefaultServerConfig.validateNonNegative(maxNumRequestsPerConnection, "maxNumRequestsPerConnection");
        this.maxConnectionAgeMillis = maxConnectionAgeMillis;
        this.connectionDrainDurationMicros = DefaultServerConfig.validateNonNegative(connectionDrainDurationMicros, "connectionDrainDurationMicros");
        this.http2InitialConnectionWindowSize = http2InitialConnectionWindowSize;
        this.http2InitialStreamWindowSize = http2InitialStreamWindowSize;
        this.http2MaxStreamsPerConnection = http2MaxStreamsPerConnection;
        this.http2MaxFrameSize = http2MaxFrameSize;
        this.http2MaxHeaderListSize = http2MaxHeaderListSize;
        this.http2MaxResetFramesPerWindow = http2MaxResetFramesPerWindow;
        this.http2MaxResetFramesWindowSeconds = http2MaxResetFramesWindowSeconds;
        this.http1MaxInitialLineLength = DefaultServerConfig.validateNonNegative(http1MaxInitialLineLength, "http1MaxInitialLineLength");
        this.http1MaxHeaderSize = DefaultServerConfig.validateNonNegative(http1MaxHeaderSize, "http1MaxHeaderSize");
        this.http1MaxChunkSize = DefaultServerConfig.validateNonNegative(http1MaxChunkSize, "http1MaxChunkSize");
        this.gracefulShutdownQuietPeriod = DefaultServerConfig.validateNonNegative(Objects.requireNonNull(gracefulShutdownQuietPeriod), "gracefulShutdownQuietPeriod");
        this.gracefulShutdownTimeout = DefaultServerConfig.validateNonNegative(Objects.requireNonNull(gracefulShutdownTimeout), "gracefulShutdownTimeout");
        DefaultServerConfig.validateGreaterThanOrEqual(gracefulShutdownTimeout, "gracefulShutdownTimeout", gracefulShutdownQuietPeriod, "gracefulShutdownQuietPeriod");
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.blockingTaskExecutor = DefaultServerConfig.monitorBlockingTaskExecutor(blockingTaskExecutor, meterRegistry);
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.channelOptions = Collections.unmodifiableMap(new Object2ObjectArrayMap(Objects.requireNonNull(channelOptions, "channelOptions")));
        this.childChannelOptions = Collections.unmodifiableMap(new Object2ObjectArrayMap(Objects.requireNonNull(childChannelOptions, "childChannelOptions")));
        this.childChannelPipelineCustomizer = Objects.requireNonNull(childChannelPipelineCustomizer, "childChannelPipelineCustomizer");
        this.clientAddressSources = ImmutableList.copyOf((Collection)Objects.requireNonNull(clientAddressSources, "clientAddressSources"));
        this.clientAddressTrustedProxyFilter = Objects.requireNonNull(clientAddressTrustedProxyFilter, "clientAddressTrustedProxyFilter");
        this.clientAddressFilter = Objects.requireNonNull(clientAddressFilter, "clientAddressFilter");
        this.clientAddressMapper = Objects.requireNonNull(clientAddressMapper, "clientAddressMapper");
        ArrayList<ServerPort> portsCopy = new ArrayList<ServerPort>();
        for (ServerPort serverPort : ports) {
            if (serverPort == null) break;
            portsCopy.add(serverPort);
        }
        if (portsCopy.isEmpty()) {
            throw new IllegalArgumentException("no ports in the server");
        }
        this.ports = Collections.unmodifiableList(portsCopy);
        this.proxyProtocolMaxTlvSize = this.ports.stream().anyMatch(ServerPort::hasProxyProtocol) ? proxyProtocolMaxTlvSize : 0;
        ArrayList<VirtualHost> virtualHostsCopy = new ArrayList<VirtualHost>();
        if (!virtualHosts.isEmpty()) {
            for (VirtualHost h2 : virtualHosts) {
                virtualHostsCopy.add(h2);
            }
        }
        virtualHostsCopy.add(defaultVirtualHost);
        this.virtualHostAndPortMapping = virtualHosts.isEmpty() ? null : DefaultServerConfig.buildDomainAndPortMapping(defaultVirtualHost, virtualHosts);
        virtualHostsCopy.forEach(h -> h.setServerConfig(this));
        if (virtualHostsCopy.stream().allMatch(h -> h.serviceConfigs().isEmpty())) {
            throw new IllegalArgumentException("no services in the server");
        }
        this.virtualHosts = Collections.unmodifiableList(virtualHostsCopy);
        this.defaultVirtualHost = defaultVirtualHost;
        this.services = virtualHostsCopy.stream().flatMap(h -> h.serviceConfigs().stream()).collect(ImmutableList.toImmutableList());
        this.enableServerHeader = enableServerHeader;
        this.enableDateHeader = enableDateHeader;
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        this.sslContexts = sslContexts;
        this.http1HeaderNaming = Objects.requireNonNull(http1HeaderNaming, "http1HeaderNaming");
        this.dependencyInjector = Objects.requireNonNull(dependencyInjector, "dependencyInjector");
        Function<? super String, String> function = Objects.requireNonNull(absoluteUriTransformer, "absoluteUriTransformer");
        this.absoluteUriTransformer = function;
        this.unhandledExceptionsReportIntervalMillis = unhandledExceptionsReportIntervalMillis;
        this.shutdownSupports = ImmutableList.copyOf((Collection)Objects.requireNonNull(shutdownSupports, "shutdownSupports"));
    }

    private static Int2ObjectMap<Mapping<String, VirtualHost>> buildDomainAndPortMapping(VirtualHost defaultVirtualHost, List<VirtualHost> virtualHosts) {
        List portMappingVhosts = virtualHosts.stream().filter(v -> v.port() > 0).collect(ImmutableList.toImmutableList());
        Map portMappingDefaultVhosts = portMappingVhosts.stream().filter(v -> v.hostnamePattern().startsWith("*:")).collect(ImmutableMap.toImmutableMap(VirtualHost::port, Function.identity()));
        HashMap<Integer, DomainMappingBuilder> mappingsBuilder = new HashMap<Integer, DomainMappingBuilder>();
        for (VirtualHost virtualHost : portMappingVhosts) {
            int port2 = virtualHost.port();
            VirtualHost defaultVhost = MoreObjects.firstNonNull((VirtualHost)portMappingDefaultVhosts.get(port2), defaultVirtualHost);
            DomainMappingBuilder mappingBuilder = mappingsBuilder.computeIfAbsent(port2, key -> new DomainMappingBuilder<VirtualHost>(defaultVhost));
            if (defaultVhost == virtualHost) continue;
            mappingBuilder.add(virtualHost.hostnamePattern(), virtualHost);
        }
        Int2ObjectOpenHashMap<Mapping<String, VirtualHost>> mappings = new Int2ObjectOpenHashMap<Mapping<String, VirtualHost>>(mappingsBuilder.size() + 1);
        mappingsBuilder.forEach((port, builder) -> mappings.put((int)port, (Mapping<String, VirtualHost>)builder.build()));
        mappings.put(-1, DefaultServerConfig.buildDomainMapping(defaultVirtualHost, virtualHosts));
        return mappings;
    }

    private static Mapping<String, VirtualHost> buildDomainMapping(VirtualHost defaultVirtualHost, List<VirtualHost> virtualHosts) {
        DomainMappingBuilder<VirtualHost> mappingBuilder = new DomainMappingBuilder<VirtualHost>(defaultVirtualHost);
        for (VirtualHost h : virtualHosts) {
            if (h.port() > 0) continue;
            mappingBuilder.add(h.hostnamePattern(), h);
        }
        return mappingBuilder.build();
    }

    private static BlockingTaskExecutor monitorBlockingTaskExecutor(BlockingTaskExecutor executor, MeterRegistry meterRegistry) {
        new ExecutorServiceMetrics((ExecutorService)executor.unwrap(), "blockingTaskExecutor", "armeria", ImmutableList.of()).bindTo(meterRegistry);
        return executor;
    }

    static int validateMaxNumConnections(int maxNumConnections) {
        return ConnectionLimitingHandler.validateMaxNumConnections(maxNumConnections);
    }

    static long validateIdleTimeoutMillis(long idleTimeoutMillis) {
        if (idleTimeoutMillis < 0L) {
            throw new IllegalArgumentException("idleTimeoutMillis: " + idleTimeoutMillis + " (expected: >= 0)");
        }
        return idleTimeoutMillis;
    }

    static long validateNonNegative(long value, String fieldName) {
        if (value < 0L) {
            throw new IllegalArgumentException(fieldName + ": " + value + " (expected: >= 0)");
        }
        return value;
    }

    static int validateNonNegative(int value, String fieldName) {
        if (value < 0) {
            throw new IllegalArgumentException(fieldName + ": " + value + " (expected: >= 0)");
        }
        return value;
    }

    static Duration validateNonNegative(Duration duration, String fieldName) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException(fieldName + ": " + duration + " (expected: >= 0)");
        }
        return duration;
    }

    static void validateGreaterThanOrEqual(Duration larger, String largerFieldName, Duration smaller, String smallerFieldName) {
        if (larger.compareTo(smaller) < 0) {
            throw new IllegalArgumentException(largerFieldName + " must be greater than or equal to" + smallerFieldName);
        }
    }

    @Override
    public Server server() {
        if (this.server == null) {
            throw new IllegalStateException("Server has not been configured yet.");
        }
        return this.server;
    }

    void setServer(Server server) {
        if (this.server != null) {
            throw new IllegalStateException("ServerConfig cannot be used for more than one Server.");
        }
        this.server = Objects.requireNonNull(server, "server");
    }

    @Override
    public List<ServerPort> ports() {
        return this.ports;
    }

    @Override
    public VirtualHost defaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    @Override
    public List<VirtualHost> virtualHosts() {
        return this.virtualHosts;
    }

    @Override
    @Deprecated
    public VirtualHost findVirtualHost(String hostname) {
        if (this.virtualHostAndPortMapping == null) {
            return this.defaultVirtualHost;
        }
        Mapping virtualHostMapping = (Mapping)this.virtualHostAndPortMapping.get(-1);
        return (VirtualHost)virtualHostMapping.map((Object)hostname);
    }

    @Override
    public VirtualHost findVirtualHost(String hostname, int port) {
        VirtualHost virtualHost;
        if (this.virtualHostAndPortMapping == null) {
            return this.defaultVirtualHost;
        }
        Mapping virtualHostMapping = (Mapping)this.virtualHostAndPortMapping.get(port);
        if (virtualHostMapping != null && (virtualHost = (VirtualHost)virtualHostMapping.map((Object)(hostname + ':' + port))) != this.defaultVirtualHost) {
            return virtualHost;
        }
        Mapping nameBasedMapping = (Mapping)this.virtualHostAndPortMapping.get(-1);
        assert (nameBasedMapping != null);
        return (VirtualHost)nameBasedMapping.map((Object)hostname);
    }

    @Override
    public List<VirtualHost> findVirtualHosts(HttpService service) {
        Objects.requireNonNull(service, "service");
        Class<?> serviceType = service.getClass();
        ArrayList<VirtualHost> res = new ArrayList<VirtualHost>();
        block0: for (VirtualHost h : this.virtualHosts) {
            for (ServiceConfig c : h.serviceConfigs()) {
                HttpService unwrapped = (HttpService)c.service().as(serviceType);
                if (unwrapped == null || unwrapped != service) continue;
                res.add(c.virtualHost());
                continue block0;
            }
        }
        return res;
    }

    @Override
    public List<ServiceConfig> serviceConfigs() {
        return this.services;
    }

    @Override
    public EventLoopGroup workerGroup() {
        return this.workerGroup;
    }

    @Override
    public boolean shutdownWorkerGroupOnStop() {
        return this.shutdownWorkerGroupOnStop;
    }

    Executor startStopExecutor() {
        return this.startStopExecutor;
    }

    @Override
    public Map<ChannelOption<?>, ?> channelOptions() {
        return this.channelOptions;
    }

    @Override
    public Map<ChannelOption<?>, ?> childChannelOptions() {
        return this.childChannelOptions;
    }

    @Override
    public Consumer<? super ChannelPipeline> childChannelPipelineCustomizer() {
        return this.childChannelPipelineCustomizer;
    }

    @Override
    public int maxNumConnections() {
        return this.maxNumConnections;
    }

    @Override
    public long idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    @Override
    public boolean keepAliveOnPing() {
        return this.keepAliveOnPing;
    }

    @Override
    public long pingIntervalMillis() {
        return this.pingIntervalMillis;
    }

    @Override
    public long maxConnectionAgeMillis() {
        return this.maxConnectionAgeMillis;
    }

    @Override
    public long connectionDrainDurationMicros() {
        return this.connectionDrainDurationMicros;
    }

    @Override
    public int maxNumRequestsPerConnection() {
        return this.maxNumRequestsPerConnection;
    }

    @Override
    public int http1MaxInitialLineLength() {
        return this.http1MaxInitialLineLength;
    }

    @Override
    public int http1MaxHeaderSize() {
        return this.http1MaxHeaderSize;
    }

    @Override
    public int http1MaxChunkSize() {
        return this.http1MaxChunkSize;
    }

    @Override
    public int http2InitialConnectionWindowSize() {
        return this.http2InitialConnectionWindowSize;
    }

    @Override
    public int http2InitialStreamWindowSize() {
        return this.http2InitialStreamWindowSize;
    }

    @Override
    public long http2MaxStreamsPerConnection() {
        return this.http2MaxStreamsPerConnection;
    }

    @Override
    public int http2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    @Override
    public long http2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    @Override
    public int http2MaxResetFramesPerWindow() {
        return this.http2MaxResetFramesPerWindow;
    }

    @Override
    public int http2MaxResetFramesWindowSeconds() {
        return this.http2MaxResetFramesWindowSeconds;
    }

    @Override
    public Duration gracefulShutdownQuietPeriod() {
        return this.gracefulShutdownQuietPeriod;
    }

    @Override
    public Duration gracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    @Override
    public BlockingTaskExecutor blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public int proxyProtocolMaxTlvSize() {
        return this.proxyProtocolMaxTlvSize;
    }

    @Override
    public List<ClientAddressSource> clientAddressSources() {
        return this.clientAddressSources;
    }

    @Override
    public Predicate<? super InetAddress> clientAddressTrustedProxyFilter() {
        return this.clientAddressTrustedProxyFilter;
    }

    @Override
    public Predicate<? super InetAddress> clientAddressFilter() {
        return this.clientAddressFilter;
    }

    @Override
    public Function<? super ProxiedAddresses, ? extends InetSocketAddress> clientAddressMapper() {
        return this.clientAddressMapper;
    }

    @Override
    public boolean isServerHeaderEnabled() {
        return this.enableServerHeader;
    }

    @Override
    public boolean isDateHeaderEnabled() {
        return this.enableDateHeader;
    }

    @Override
    public Function<RoutingContext, RequestId> requestIdGenerator() {
        return this.defaultVirtualHost.requestIdGenerator();
    }

    @Override
    public ServerErrorHandler errorHandler() {
        return this.errorHandler;
    }

    @Nullable
    Mapping<String, SslContext> sslContextMapping() {
        return this.sslContexts;
    }

    @Override
    public Http1HeaderNaming http1HeaderNaming() {
        return this.http1HeaderNaming;
    }

    @Override
    public DependencyInjector dependencyInjector() {
        return this.dependencyInjector;
    }

    @Override
    public Function<String, String> absoluteUriTransformer() {
        return this.absoluteUriTransformer;
    }

    @Override
    public long unhandledExceptionsReportIntervalMillis() {
        return this.unhandledExceptionsReportIntervalMillis;
    }

    List<ShutdownSupport> shutdownSupports() {
        return this.shutdownSupports;
    }

    public String toString() {
        String strVal = this.strVal;
        if (strVal == null) {
            this.strVal = strVal = DefaultServerConfig.toString(this.getClass(), this.ports(), null, this.virtualHosts(), this.workerGroup(), this.shutdownWorkerGroupOnStop(), this.maxNumConnections(), this.idleTimeoutMillis(), this.http2InitialConnectionWindowSize(), this.http2InitialStreamWindowSize(), this.http2MaxStreamsPerConnection(), this.http2MaxFrameSize(), this.http2MaxHeaderListSize(), this.http1MaxInitialLineLength(), this.http1MaxHeaderSize(), this.http1MaxChunkSize(), this.proxyProtocolMaxTlvSize(), this.gracefulShutdownQuietPeriod(), this.gracefulShutdownTimeout(), this.blockingTaskExecutor(), this.meterRegistry(), this.channelOptions(), this.childChannelOptions(), this.clientAddressSources(), this.clientAddressTrustedProxyFilter(), this.clientAddressFilter(), this.clientAddressMapper(), this.isServerHeaderEnabled(), this.isDateHeaderEnabled(), this.dependencyInjector(), this.absoluteUriTransformer(), this.unhandledExceptionsReportIntervalMillis());
        }
        return strVal;
    }

    static String toString(@Nullable Class<?> type, Iterable<ServerPort> ports, @Nullable VirtualHost defaultVirtualHost, List<VirtualHost> virtualHosts, EventLoopGroup workerGroup, boolean shutdownWorkerGroupOnStop, int maxNumConnections, long idleTimeoutMillis, int http2InitialConnectionWindowSize, int http2InitialStreamWindowSize, long http2MaxStreamsPerConnection, int http2MaxFrameSize, long http2MaxHeaderListSize, long http1MaxInitialLineLength, long http1MaxHeaderSize, long http1MaxChunkSize, int proxyProtocolMaxTlvSize, Duration gracefulShutdownQuietPeriod, Duration gracefulShutdownTimeout, @Nullable BlockingTaskExecutor blockingTaskExecutor, @Nullable MeterRegistry meterRegistry, Map<ChannelOption<?>, ?> channelOptions, Map<ChannelOption<?>, ?> childChannelOptions, List<ClientAddressSource> clientAddressSources, Predicate<? super InetAddress> clientAddressTrustedProxyFilter, Predicate<? super InetAddress> clientAddressFilter, Function<? super ProxiedAddresses, ? extends InetSocketAddress> clientAddressMapper, boolean serverHeaderEnabled, boolean dateHeaderEnabled, @Nullable DependencyInjector dependencyInjector, Function<? super String, String> absoluteUriTransformer, long unhandledExceptionsReportIntervalMillis) {
        StringBuilder buf = new StringBuilder();
        if (type != null) {
            buf.append(type.getSimpleName());
        }
        buf.append("(ports: [");
        boolean hasPorts = false;
        for (ServerPort p : ports) {
            buf.append(ServerPort.toString(null, p.localAddress(), p.protocols(), p.portGroup()));
            buf.append(", ");
            hasPorts = true;
        }
        if (hasPorts) {
            buf.setCharAt(buf.length() - 2, ']');
            buf.setCharAt(buf.length() - 1, ',');
        } else {
            buf.append("],");
        }
        buf.append(" virtualHosts: [");
        if (!virtualHosts.isEmpty()) {
            virtualHosts.forEach(virtualHost -> {
                buf.append(virtualHost.toStringWithoutTypeName());
                buf.append(", ");
            });
            if (defaultVirtualHost != null) {
                buf.append(defaultVirtualHost.toStringWithoutTypeName());
            } else {
                buf.setLength(buf.length() - 2);
            }
        } else if (defaultVirtualHost != null) {
            buf.append(defaultVirtualHost.toStringWithoutTypeName());
        }
        buf.append("], workerGroup: ");
        buf.append(workerGroup);
        buf.append(" (shutdownOnStop=");
        buf.append(shutdownWorkerGroupOnStop);
        buf.append("), maxNumConnections: ");
        buf.append(maxNumConnections);
        buf.append(", idleTimeout: ");
        buf.append(idleTimeoutMillis);
        buf.append("ms, http2InitialConnectionWindowSize: ");
        buf.append(http2InitialConnectionWindowSize);
        buf.append("B, http2InitialStreamWindowSize: ");
        buf.append(http2InitialStreamWindowSize);
        buf.append("B, http2MaxStreamsPerConnection: ");
        buf.append(http2MaxStreamsPerConnection);
        buf.append(", http2MaxFrameSize: ");
        buf.append(http2MaxFrameSize);
        buf.append("B, http2MaxHeaderListSize: ");
        buf.append(http2MaxHeaderListSize);
        buf.append("B, http1MaxInitialLineLength: ");
        buf.append(http1MaxInitialLineLength);
        buf.append("B, http1MaxHeaderSize: ");
        buf.append(http1MaxHeaderSize);
        buf.append("B, http1MaxChunkSize: ");
        buf.append(http1MaxChunkSize);
        buf.append("B, proxyProtocolMaxTlvSize: ");
        buf.append(proxyProtocolMaxTlvSize);
        buf.append("B, gracefulShutdownQuietPeriod: ");
        buf.append(gracefulShutdownQuietPeriod);
        buf.append(", gracefulShutdownTimeout: ");
        buf.append(gracefulShutdownTimeout);
        if (blockingTaskExecutor != null) {
            buf.append(", blockingTaskExecutor: ");
            buf.append(blockingTaskExecutor);
        }
        if (meterRegistry != null) {
            buf.append(", meterRegistry: ");
            buf.append(meterRegistry);
        }
        buf.append(", channelOptions: ");
        buf.append(channelOptions);
        buf.append(", childChannelOptions: ");
        buf.append(childChannelOptions);
        buf.append(", clientAddressSources: ");
        buf.append(clientAddressSources);
        buf.append(", clientAddressTrustedProxyFilter: ");
        buf.append(clientAddressTrustedProxyFilter);
        buf.append(", clientAddressFilter: ");
        buf.append(clientAddressFilter);
        buf.append(", clientAddressMapper: ");
        buf.append(clientAddressMapper);
        buf.append(", serverHeader: ");
        buf.append(serverHeaderEnabled ? "enabled" : "disabled");
        buf.append(", dateHeader: ");
        buf.append(dateHeaderEnabled ? "enabled" : "disabled");
        if (dependencyInjector != null) {
            buf.append(", dependencyInjector: ");
            buf.append(dependencyInjector);
        }
        buf.append(", absoluteUriTransformer: ");
        buf.append(absoluteUriTransformer);
        buf.append(", unhandledExceptionsReportIntervalMillis: ");
        buf.append(unhandledExceptionsReportIntervalMillis);
        buf.append(')');
        return buf.toString();
    }
}

