/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.common.TimeoutException;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RequestTimeoutException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class DefaultCancellationScheduler
implements CancellationScheduler {
    private static final AtomicReferenceFieldUpdater<DefaultCancellationScheduler, CancellationFuture> whenCancellingUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultCancellationScheduler.class, CancellationFuture.class, "whenCancelling");
    private static final AtomicReferenceFieldUpdater<DefaultCancellationScheduler, CancellationFuture> whenCancelledUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultCancellationScheduler.class, CancellationFuture.class, "whenCancelled");
    private static final AtomicReferenceFieldUpdater<DefaultCancellationScheduler, TimeoutFuture> whenTimingOutUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultCancellationScheduler.class, TimeoutFuture.class, "whenTimingOut");
    private static final AtomicReferenceFieldUpdater<DefaultCancellationScheduler, TimeoutFuture> whenTimedOutUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultCancellationScheduler.class, TimeoutFuture.class, "whenTimedOut");
    private static final AtomicReferenceFieldUpdater<DefaultCancellationScheduler, Runnable> pendingTaskUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultCancellationScheduler.class, Runnable.class, "pendingTask");
    private static final AtomicLongFieldUpdater<DefaultCancellationScheduler> pendingTimeoutNanosUpdater = AtomicLongFieldUpdater.newUpdater(DefaultCancellationScheduler.class, "pendingTimeoutNanos");
    private static final Runnable noopPendingTask = () -> {};
    static final CancellationScheduler serverFinishedCancellationScheduler = DefaultCancellationScheduler.finished0(true);
    static final CancellationScheduler clientFinishedCancellationScheduler = DefaultCancellationScheduler.finished0(false);
    private CancellationScheduler.State state = CancellationScheduler.State.INIT;
    private long timeoutNanos;
    private long startTimeNanos;
    @Nullable
    private EventExecutor eventLoop;
    @Nullable
    private CancellationScheduler.CancellationTask task;
    @Nullable
    private volatile Runnable pendingTask;
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @Nullable
    private volatile CancellationFuture whenCancelling;
    @Nullable
    private volatile CancellationFuture whenCancelled;
    @Nullable
    private volatile TimeoutFuture whenTimingOut;
    @Nullable
    private volatile TimeoutFuture whenTimedOut;
    private volatile long pendingTimeoutNanos;
    private final boolean server;
    @Nullable
    private Throwable cause;

    DefaultCancellationScheduler(long timeoutNanos) {
        this(timeoutNanos, true);
    }

    DefaultCancellationScheduler(long timeoutNanos, boolean server) {
        this.timeoutNanos = timeoutNanos;
        this.pendingTimeoutNanos = timeoutNanos;
        this.server = server;
    }

    @Override
    public void initAndStart(EventExecutor eventLoop, CancellationScheduler.CancellationTask task) {
        this.init(eventLoop);
        if (!eventLoop.inEventLoop()) {
            eventLoop.execute(() -> this.start(task));
        } else {
            this.start(task);
        }
    }

    @Override
    public void init(EventExecutor eventLoop) {
        Preconditions.checkState(this.eventLoop == null, "Can't init() more than once");
        this.eventLoop = eventLoop;
    }

    @Override
    public void start(CancellationScheduler.CancellationTask task) {
        block8: {
            Runnable pendingTask;
            assert (this.eventLoop != null);
            assert (this.eventLoop.inEventLoop());
            if (this.isFinished()) {
                assert (this.cause != null);
                task.run(this.cause);
                return;
            }
            if (this.task != null) {
                this.task = task;
                return;
            }
            this.task = task;
            this.startTimeNanos = System.nanoTime();
            if (this.timeoutNanos != 0L) {
                this.state = CancellationScheduler.State.SCHEDULED;
                this.scheduledFuture = this.eventLoop.schedule(() -> this.invokeTask(null), this.timeoutNanos, TimeUnit.NANOSECONDS);
            } else {
                this.state = CancellationScheduler.State.INACTIVE;
            }
            while (!pendingTaskUpdater.compareAndSet(this, pendingTask = this.pendingTask, noopPendingTask)) {
            }
            if (pendingTask == null) break block8;
            pendingTask.run();
        }
    }

    @Override
    public void clearTimeout() {
        this.clearTimeout(true);
    }

    @Override
    public void clearTimeout(boolean resetTimeout) {
        if (this.timeoutNanos() == 0L) {
            return;
        }
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.clearTimeout0(resetTimeout);
            } else {
                this.eventLoop.execute(() -> this.clearTimeout0(resetTimeout));
            }
        } else {
            if (resetTimeout) {
                this.setPendingTimeoutNanos(0L);
            }
            this.addPendingTask(() -> this.clearTimeout0(resetTimeout));
        }
    }

    private boolean clearTimeout0(boolean resetTimeout) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop());
        if (this.state != CancellationScheduler.State.SCHEDULED) {
            return true;
        }
        if (resetTimeout) {
            this.timeoutNanos = 0L;
        }
        assert (this.scheduledFuture != null);
        boolean cancelled = this.scheduledFuture.cancel(false);
        this.scheduledFuture = null;
        if (cancelled) {
            this.state = CancellationScheduler.State.INACTIVE;
        }
        return cancelled;
    }

    @Override
    public void setTimeoutNanos(TimeoutMode mode, long timeoutNanos) {
        switch (mode) {
            case SET_FROM_NOW: {
                this.setTimeoutNanosFromNow(timeoutNanos);
                break;
            }
            case SET_FROM_START: {
                this.setTimeoutNanosFromStart(timeoutNanos);
                break;
            }
            case EXTEND: {
                this.extendTimeoutNanos(timeoutNanos);
            }
        }
    }

    private void setTimeoutNanosFromStart(long timeoutNanos) {
        Preconditions.checkArgument(timeoutNanos >= 0L, "timeoutNanos: %s (expected: >= 0)", timeoutNanos);
        if (timeoutNanos == 0L) {
            this.clearTimeout();
            return;
        }
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.setTimeoutNanosFromStart0(timeoutNanos);
            } else {
                this.eventLoop.execute(() -> this.setTimeoutNanosFromStart0(timeoutNanos));
            }
        } else {
            this.setPendingTimeoutNanos(timeoutNanos);
            this.addPendingTask(() -> this.setTimeoutNanosFromStart0(timeoutNanos));
        }
    }

    private void setTimeoutNanosFromStart0(long timeoutNanos) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop());
        long passedTimeNanos = System.nanoTime() - this.startTimeNanos;
        long newTimeoutNanos = LongMath.saturatedSubtract(timeoutNanos, passedTimeNanos);
        if (newTimeoutNanos <= 0L) {
            this.invokeTask(null);
            return;
        }
        this.clearTimeout0(true);
        this.timeoutNanos = timeoutNanos;
        this.state = CancellationScheduler.State.SCHEDULED;
        this.scheduledFuture = this.eventLoop.schedule(() -> this.invokeTask(null), newTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    private void extendTimeoutNanos(long adjustmentNanos) {
        if (adjustmentNanos == 0L || this.timeoutNanos() == 0L) {
            return;
        }
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.extendTimeoutNanos0(adjustmentNanos);
            } else {
                this.eventLoop.execute(() -> this.extendTimeoutNanos0(adjustmentNanos));
            }
        } else {
            this.addPendingTimeoutNanos(adjustmentNanos);
            this.addPendingTask(() -> this.extendTimeoutNanos0(adjustmentNanos));
        }
    }

    private void extendTimeoutNanos0(long adjustmentNanos) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop() && this.task != null);
        if (this.state != CancellationScheduler.State.SCHEDULED || !this.task.canSchedule()) {
            return;
        }
        long timeoutNanos = this.timeoutNanos;
        this.clearTimeout0(true);
        this.timeoutNanos = LongMath.saturatedAdd(timeoutNanos, adjustmentNanos);
        if (timeoutNanos <= 0L) {
            this.invokeTask(null);
            return;
        }
        this.state = CancellationScheduler.State.SCHEDULED;
        this.scheduledFuture = this.eventLoop.schedule(() -> this.invokeTask(null), this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    private void setTimeoutNanosFromNow(long timeoutNanos) {
        Preconditions.checkArgument(timeoutNanos > 0L, "timeoutNanos: %s (expected: > 0)", timeoutNanos);
        if (this.isInitialized()) {
            if (this.eventLoop.inEventLoop()) {
                this.setTimeoutNanosFromNow0(timeoutNanos);
            } else {
                long eventLoopStartTimeNanos = System.nanoTime();
                this.eventLoop.execute(() -> {
                    long passedTimeNanos0 = System.nanoTime() - eventLoopStartTimeNanos;
                    long timeoutNanos0 = Math.max(1L, timeoutNanos - passedTimeNanos0);
                    this.setTimeoutNanosFromNow0(timeoutNanos0);
                });
            }
        } else {
            long pendingTaskRegisterTimeNanos = System.nanoTime();
            this.setPendingTimeoutNanos(timeoutNanos);
            this.addPendingTask(() -> {
                long passedTimeNanos0 = System.nanoTime() - pendingTaskRegisterTimeNanos;
                long timeoutNanos0 = Math.max(1L, timeoutNanos - passedTimeNanos0);
                this.setTimeoutNanosFromNow0(timeoutNanos0);
            });
        }
    }

    private void setTimeoutNanosFromNow0(long newTimeoutNanos) {
        assert (newTimeoutNanos > 0L);
        assert (this.eventLoop != null && this.eventLoop.inEventLoop() && this.task != null);
        if (this.isFinishing() || !this.task.canSchedule()) {
            return;
        }
        this.clearTimeout0(true);
        long passedTimeNanos = System.nanoTime() - this.startTimeNanos;
        this.timeoutNanos = LongMath.saturatedAdd(newTimeoutNanos, passedTimeNanos);
        this.state = CancellationScheduler.State.SCHEDULED;
        this.scheduledFuture = this.eventLoop.schedule(() -> this.invokeTask(null), newTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void finishNow() {
        this.finishNow(null);
    }

    @Override
    public void finishNow(@Nullable Throwable cause) {
        if (this.isFinishing()) {
            return;
        }
        assert (this.eventLoop != null);
        if (!this.eventLoop.inEventLoop()) {
            this.eventLoop.execute(() -> this.finishNow(cause));
            return;
        }
        if (this.isInitialized()) {
            this.finishNow0(cause);
        } else {
            this.start(noopCancellationTask);
            this.finishNow0(cause);
        }
    }

    private void finishNow0(@Nullable Throwable cause) {
        assert (this.eventLoop != null && this.eventLoop.inEventLoop() && this.task != null);
        if (this.isFinishing() || !this.task.canSchedule()) {
            return;
        }
        if (this.state == CancellationScheduler.State.SCHEDULED) {
            if (this.clearTimeout0(false)) {
                this.invokeTask(cause);
            }
        } else {
            this.invokeTask(cause);
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == CancellationScheduler.State.FINISHED;
    }

    private boolean isFinishing() {
        return this.state == CancellationScheduler.State.FINISHED || this.state == CancellationScheduler.State.FINISHING;
    }

    @Override
    @Nullable
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public long timeoutNanos() {
        return this.isInitialized() ? this.timeoutNanos : this.pendingTimeoutNanos;
    }

    @Override
    public long startTimeNanos() {
        return this.startTimeNanos;
    }

    @Override
    public CompletableFuture<Throwable> whenCancelling() {
        CancellationFuture whenCancelling = this.whenCancelling;
        if (whenCancelling != null) {
            return whenCancelling;
        }
        CancellationFuture cancellationFuture = new CancellationFuture();
        if (whenCancellingUpdater.compareAndSet(this, null, cancellationFuture)) {
            return cancellationFuture;
        }
        return this.whenCancelling;
    }

    @Override
    public CompletableFuture<Throwable> whenCancelled() {
        CancellationFuture whenCancelled = this.whenCancelled;
        if (whenCancelled != null) {
            return whenCancelled;
        }
        CancellationFuture cancellationFuture = new CancellationFuture();
        if (whenCancelledUpdater.compareAndSet(this, null, cancellationFuture)) {
            return cancellationFuture;
        }
        return this.whenCancelled;
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenTimingOut() {
        TimeoutFuture whenTimingOut = this.whenTimingOut;
        if (whenTimingOut != null) {
            return whenTimingOut;
        }
        TimeoutFuture timeoutFuture = new TimeoutFuture();
        if (whenTimingOutUpdater.compareAndSet(this, null, timeoutFuture)) {
            this.whenCancelling().thenAccept(cause -> {
                if (cause instanceof TimeoutException) {
                    timeoutFuture.doComplete();
                }
            });
            return timeoutFuture;
        }
        return this.whenTimingOut;
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenTimedOut() {
        TimeoutFuture whenTimedOut = this.whenTimedOut;
        if (whenTimedOut != null) {
            return whenTimedOut;
        }
        TimeoutFuture timeoutFuture = new TimeoutFuture();
        if (whenTimedOutUpdater.compareAndSet(this, null, timeoutFuture)) {
            this.whenCancelled().thenAccept(cause -> {
                if (cause instanceof TimeoutException) {
                    timeoutFuture.doComplete();
                }
            });
            return timeoutFuture;
        }
        return this.whenTimedOut;
    }

    private boolean isInitialized() {
        return this.pendingTask == noopPendingTask && this.eventLoop != null;
    }

    private void addPendingTask(Runnable pendingTask) {
        block3: {
            Runnable newPendingTask;
            Runnable oldPendingTask;
            if (pendingTaskUpdater.compareAndSet(this, null, pendingTask)) break block3;
            do {
                oldPendingTask = this.pendingTask;
                assert (oldPendingTask != null);
                if (oldPendingTask != noopPendingTask) continue;
                assert (this.eventLoop != null);
                this.eventLoop.execute(pendingTask);
                break;
            } while (!pendingTaskUpdater.compareAndSet(this, oldPendingTask, newPendingTask = () -> {
                oldPendingTask.run();
                pendingTask.run();
            }));
        }
    }

    private void setPendingTimeoutNanos(long pendingTimeoutNanos) {
        long oldPendingTimeoutNanos;
        while (!pendingTimeoutNanosUpdater.compareAndSet(this, oldPendingTimeoutNanos = this.pendingTimeoutNanos, pendingTimeoutNanos)) {
        }
    }

    private void addPendingTimeoutNanos(long pendingTimeoutNanos) {
        long newPendingTimeoutNanos;
        long oldPendingTimeoutNanos;
        while (!pendingTimeoutNanosUpdater.compareAndSet(this, oldPendingTimeoutNanos = this.pendingTimeoutNanos, newPendingTimeoutNanos = LongMath.saturatedAdd(oldPendingTimeoutNanos, pendingTimeoutNanos))) {
        }
    }

    private void invokeTask(@Nullable Throwable cause) {
        if (this.task == null) {
            return;
        }
        if (cause instanceof HttpStatusException || cause instanceof HttpResponseException) {
            cause = cause.getCause();
        }
        if (cause == null) {
            cause = this.server ? RequestTimeoutException.get() : ResponseTimeoutException.get();
        }
        this.state = CancellationScheduler.State.FINISHING;
        if (this.task.canSchedule()) {
            ((CancellationFuture)this.whenCancelling()).doComplete(cause);
        }
        this.state = CancellationScheduler.State.FINISHED;
        if (this.task.canSchedule()) {
            this.task.run(cause);
        }
        this.cause = cause;
        ((CancellationFuture)this.whenCancelled()).doComplete(cause);
    }

    CancellationScheduler.State state() {
        return this.state;
    }

    private static CancellationScheduler finished0(boolean server) {
        DefaultCancellationScheduler cancellationScheduler = new DefaultCancellationScheduler(0L, server);
        cancellationScheduler.initAndStart((EventExecutor)ImmediateEventExecutor.INSTANCE, noopCancellationTask);
        cancellationScheduler.finishNow();
        return cancellationScheduler;
    }

    private static class CancellationFuture
    extends UnmodifiableFuture<Throwable> {
        private CancellationFuture() {
        }

        @Override
        protected void doComplete(@Nullable Throwable cause) {
            super.doComplete(cause);
        }
    }

    private static class TimeoutFuture
    extends UnmodifiableFuture<Void> {
        private TimeoutFuture() {
        }

        void doComplete() {
            this.doComplete(null);
        }
    }
}

