/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpRequestDuplicatorWrapper;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.client.redirect.CyclicRedirectsException;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.client.redirect.TooManyRedirectsException;
import com.linecorp.armeria.client.redirect.UnexpectedDomainRedirectException;
import com.linecorp.armeria.client.redirect.UnexpectedProtocolRedirectException;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestDuplicator;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.internal.client.AggregatedHttpRequestDuplicator;
import com.linecorp.armeria.internal.client.ClientUtil;
import com.linecorp.armeria.internal.client.RedirectingClientUtil;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.LinkedListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Function;

final class RedirectingClient
extends SimpleDecoratingHttpClient {
    private static final Set<HttpStatus> redirectStatuses = ImmutableSet.of(HttpStatus.MOVED_PERMANENTLY, HttpStatus.FOUND, HttpStatus.SEE_OTHER, HttpStatus.TEMPORARY_REDIRECT);
    private static final Set<SessionProtocol> httpAndHttps = Sets.immutableEnumSet((Enum)SessionProtocol.HTTP, (Enum[])new SessionProtocol[]{SessionProtocol.HTTPS});
    private final Set<SessionProtocol> allowedProtocols;
    private final BiPredicate<ClientRequestContext, String> domainFilter;
    private final int maxRedirects;

    static Function<? super HttpClient, RedirectingClient> newDecorator(ClientBuilderParams params, RedirectConfig redirectConfig) {
        boolean undefinedUri = Clients.isUndefinedUri(params.uri());
        Set<SessionProtocol> allowedProtocols = RedirectingClient.allowedProtocols(undefinedUri, redirectConfig.allowedProtocols(), params.scheme().sessionProtocol());
        BiPredicate<ClientRequestContext, String> domainFilter = RedirectingClient.domainFilter(undefinedUri, redirectConfig.domainFilter());
        return delegate -> new RedirectingClient((HttpClient)delegate, allowedProtocols, domainFilter, redirectConfig.maxRedirects());
    }

    private static Set<SessionProtocol> allowedProtocols(boolean undefinedUri, @Nullable Set<SessionProtocol> allowedProtocols, SessionProtocol usedProtocol) {
        if (undefinedUri) {
            if (allowedProtocols != null) {
                return allowedProtocols;
            }
            return httpAndHttps;
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(2);
        if (allowedProtocols != null) {
            builder.addAll(allowedProtocols);
        } else {
            builder.add((Object)SessionProtocol.HTTPS);
        }
        if (usedProtocol.isHttp()) {
            builder.add((Object)SessionProtocol.HTTP);
        } else if (usedProtocol.isHttps()) {
            builder.add((Object)SessionProtocol.HTTPS);
        }
        return builder.build();
    }

    private static BiPredicate<ClientRequestContext, String> domainFilter(boolean undefinedUri, @Nullable BiPredicate<ClientRequestContext, String> domainFilter) {
        if (domainFilter != null) {
            return domainFilter;
        }
        if (undefinedUri) {
            return RedirectingClientUtil.allowAllDomains;
        }
        return RedirectingClientUtil.allowSameDomain;
    }

    RedirectingClient(HttpClient delegate, Set<SessionProtocol> allowedProtocols, BiPredicate<ClientRequestContext, String> domainFilter, int maxRedirects) {
        super(delegate);
        this.allowedProtocols = allowedProtocols;
        this.domainFilter = domainFilter;
        this.maxRedirects = maxRedirects;
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse res = HttpResponse.of(responseFuture, (EventExecutor)ctx.eventLoop());
        RedirectContext redirectCtx = new RedirectContext(ctx, req, res, responseFuture);
        if (ctx.exchangeType().isRequestStreaming()) {
            HttpRequestDuplicator reqDuplicator = req.toDuplicator((EventExecutor)ctx.eventLoop().withoutContext(), 0L);
            this.execute0(ctx, redirectCtx, reqDuplicator, true);
        } else {
            req.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), (EventExecutor)ctx.eventLoop())).handle((agg, cause) -> {
                if (cause != null) {
                    RedirectingClient.handleException(ctx, null, responseFuture, cause, true);
                } else {
                    AggregatedHttpRequestDuplicator reqDuplicator = new AggregatedHttpRequestDuplicator((AggregatedHttpRequest)agg);
                    this.execute0(ctx, redirectCtx, reqDuplicator, true);
                }
                return null;
            });
        }
        return res;
    }

    private void execute0(ClientRequestContext ctx, RedirectContext redirectCtx, HttpRequestDuplicator reqDuplicator, boolean initialAttempt) {
        ClientRequestContext derivedCtx;
        CompletableFuture<Void> originalReqWhenComplete = redirectCtx.request().whenComplete();
        CompletableFuture<HttpResponse> responseFuture = redirectCtx.responseFuture();
        if (originalReqWhenComplete.isCompletedExceptionally()) {
            originalReqWhenComplete.exceptionally(cause -> {
                RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, cause, initialAttempt);
                return null;
            });
            return;
        }
        if (redirectCtx.responseWhenComplete().isDone()) {
            redirectCtx.responseWhenComplete().handle((result, cause) -> {
                Throwable abortCause = cause != null ? cause : AbortedStreamException.get();
                RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, abortCause, initialAttempt);
                return null;
            });
            return;
        }
        HttpRequest duplicateReq = reqDuplicator.duplicate();
        try {
            derivedCtx = ClientUtil.newDerivedContext(ctx, duplicateReq, ctx.rpcRequest(), initialAttempt);
        }
        catch (Throwable t) {
            RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, t, initialAttempt);
            return;
        }
        HttpResponse response = ClientUtil.executeWithFallback((Client)this.unwrap(), derivedCtx, (context, cause) -> HttpResponse.ofFailure(cause));
        derivedCtx.log().whenAvailable(RequestLogProperty.RESPONSE_HEADERS).thenAccept(log -> {
            String redirectFullUri;
            URI redirectUri;
            Throwable cause2;
            if (log.isAvailable(RequestLogProperty.RESPONSE_CAUSE) && (cause2 = log.responseCause()) != null) {
                RedirectingClient.abortResponse(response, derivedCtx, cause2);
                RedirectingClient.handleException(ctx, reqDuplicator, responseFuture, cause2, false);
                return;
            }
            ResponseHeaders responseHeaders = log.responseHeaders();
            if (!redirectStatuses.contains(responseHeaders.status())) {
                RedirectingClient.endRedirect(ctx, reqDuplicator, responseFuture, response);
                return;
            }
            String location = responseHeaders.get((CharSequence)HttpHeaderNames.LOCATION);
            if (Strings.isNullOrEmpty(location)) {
                RedirectingClient.endRedirect(ctx, reqDuplicator, responseFuture, response);
                return;
            }
            RequestHeaders requestHeaders = log.requestHeaders();
            try {
                redirectUri = URI.create(requestHeaders.path()).resolve(location);
                if (redirectUri.isAbsolute()) {
                    SessionProtocol redirectProtocol = Scheme.parse(redirectUri.getScheme()).sessionProtocol();
                    if (!this.allowedProtocols.contains((Object)redirectProtocol)) {
                        RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, UnexpectedProtocolRedirectException.of(redirectProtocol, this.allowedProtocols));
                        return;
                    }
                    if (!this.domainFilter.test(ctx, redirectUri.getHost())) {
                        RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, UnexpectedDomainRedirectException.of(redirectUri.getHost()));
                        return;
                    }
                }
            }
            catch (Throwable t) {
                RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, t);
                return;
            }
            HttpRequestDuplicator newReqDuplicator = RedirectingClient.newReqDuplicator(reqDuplicator, responseHeaders, requestHeaders, redirectUri);
            try {
                redirectFullUri = RedirectingClient.buildFullUri(ctx, redirectUri, newReqDuplicator.headers());
            }
            catch (Throwable t) {
                RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, t);
                return;
            }
            if (RedirectingClient.isCyclicRedirects(redirectCtx, redirectFullUri, newReqDuplicator.headers())) {
                RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, CyclicRedirectsException.of(redirectCtx.originalUri(), redirectCtx.redirectUris().values()));
                return;
            }
            Multimap<HttpMethod, String> redirectUris = redirectCtx.redirectUris();
            if (redirectUris.size() > this.maxRedirects) {
                RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, TooManyRedirectsException.of(this.maxRedirects, redirectCtx.originalUri(), redirectUris.values()));
                return;
            }
            response.subscribe((EventExecutor)ctx.eventLoop()).handleAsync((unused, cause) -> {
                if (cause != null) {
                    RedirectingClient.handleException(ctx, derivedCtx, reqDuplicator, responseFuture, response, cause);
                    return null;
                }
                this.execute0(ctx, redirectCtx, newReqDuplicator, false);
                return null;
            }, (Executor)ctx.eventLoop());
        });
    }

    private static HttpRequestDuplicator newReqDuplicator(HttpRequestDuplicator reqDuplicator, ResponseHeaders responseHeaders, RequestHeaders requestHeaders, URI newUri) {
        RequestHeadersBuilder builder = requestHeaders.toBuilder();
        builder.path(newUri.toString());
        String newAuthority = newUri.getAuthority();
        if (newAuthority != null) {
            builder.authority(newAuthority);
        }
        HttpMethod method = requestHeaders.method();
        if (responseHeaders.status() == HttpStatus.SEE_OTHER && method != HttpMethod.GET && method != HttpMethod.HEAD) {
            builder.method(HttpMethod.GET);
            reqDuplicator.abort();
            return new AggregatedHttpRequestDuplicator(AggregatedHttpRequest.of(builder.build()));
        }
        return new HttpRequestDuplicatorWrapper(reqDuplicator, builder.build());
    }

    private static void endRedirect(ClientRequestContext ctx, HttpRequestDuplicator reqDuplicator, CompletableFuture<HttpResponse> responseFuture, HttpResponse response) {
        ctx.logBuilder().endResponseWithLastChild();
        responseFuture.complete(response);
        reqDuplicator.close();
    }

    private static void handleException(ClientRequestContext ctx, ClientRequestContext derivedCtx, HttpRequestDuplicator reqDuplicator, CompletableFuture<HttpResponse> future, HttpResponse originalRes, Throwable cause) {
        RedirectingClient.abortResponse(originalRes, derivedCtx, cause);
        RedirectingClient.handleException(ctx, reqDuplicator, future, cause, false);
    }

    private static void handleException(ClientRequestContext ctx, @Nullable HttpRequestDuplicator reqDuplicator, CompletableFuture<HttpResponse> future, Throwable cause, boolean initialAttempt) {
        future.completeExceptionally(cause);
        if (reqDuplicator != null) {
            reqDuplicator.abort(cause);
        }
        if (initialAttempt) {
            ctx.logBuilder().endRequest(cause);
        }
        ctx.logBuilder().endResponse(cause);
    }

    private static void abortResponse(HttpResponse originalRes, ClientRequestContext derivedCtx, @Nullable Throwable cause) {
        RequestLogBuilder logBuilder = derivedCtx.logBuilder();
        logBuilder.responseContent(null, null);
        logBuilder.responseContentPreview(null);
        if (cause != null) {
            originalRes.abort(cause);
        } else {
            originalRes.abort();
        }
    }

    private static String buildFullUri(ClientRequestContext ctx, URI redirectUri, RequestHeaders newHeaders) throws URISyntaxException {
        if (redirectUri.isAbsolute()) {
            if (redirectUri.getPort() > 0) {
                return redirectUri.toString();
            }
            int port = redirectUri.getScheme().startsWith("https") ? SessionProtocol.HTTPS.defaultPort() : SessionProtocol.HTTP.defaultPort();
            return new URI(redirectUri.getScheme(), redirectUri.getRawUserInfo(), redirectUri.getHost(), port, redirectUri.getRawPath(), redirectUri.getRawQuery(), redirectUri.getRawFragment()).toString();
        }
        return RedirectingClient.buildUri(ctx, newHeaders);
    }

    private static boolean isCyclicRedirects(RedirectContext redirectCtx, String redirectUri, RequestHeaders newHeaders) {
        boolean added = redirectCtx.addRedirectUri(newHeaders.method(), redirectUri);
        if (!added) {
            return true;
        }
        return redirectCtx.originalUri().equals(redirectUri) && redirectCtx.request().method() == newHeaders.method();
    }

    private static String buildUri(ClientRequestContext ctx, RequestHeaders headers) {
        String originalUri;
        try (TemporaryThreadLocals threadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder sb = threadLocals.stringBuilder();
            if (ctx.sessionProtocol().isHttp()) {
                sb.append(SessionProtocol.HTTP.uriText());
            } else {
                sb.append(SessionProtocol.HTTPS.uriText());
            }
            sb.append("://");
            String authority = headers.authority();
            Endpoint endpoint = ctx.endpoint();
            assert (endpoint != null);
            if (authority == null) {
                authority = endpoint.authority();
            }
            RedirectingClient.setAuthorityAndPort(ctx, endpoint, sb, authority);
            sb.append(headers.path());
            originalUri = sb.toString();
        }
        return originalUri;
    }

    private static void setAuthorityAndPort(ClientRequestContext ctx, Endpoint endpoint, StringBuilder sb, String authority) {
        if (authority.charAt(0) == '[') {
            int closingBracketPos = authority.lastIndexOf(93);
            if (closingBracketPos < 0) {
                throw new IllegalStateException("Invalid authority: " + authority);
            }
            sb.append(authority);
            if (authority.indexOf(58, closingBracketPos) < 0) {
                RedirectingClient.addPort(ctx, endpoint, sb);
            }
            return;
        }
        if (NetUtil.isValidIpV6Address((String)authority)) {
            sb.append('[');
            sb.append(authority);
            sb.append(']');
            RedirectingClient.addPort(ctx, endpoint, sb);
            return;
        }
        sb.append(authority);
        if (authority.lastIndexOf(58) < 0) {
            RedirectingClient.addPort(ctx, endpoint, sb);
        }
    }

    private static void addPort(ClientRequestContext ctx, Endpoint endpoint, StringBuilder sb) {
        sb.append(':');
        sb.append(endpoint.port(ctx.sessionProtocol().defaultPort()));
    }

    static class RedirectContext {
        private final ClientRequestContext ctx;
        private final HttpRequest request;
        private final CompletableFuture<Void> responseWhenComplete;
        private final CompletableFuture<HttpResponse> responseFuture;
        @Nullable
        private Multimap<HttpMethod, String> redirectUris;
        @Nullable
        private String originalUri;

        RedirectContext(ClientRequestContext ctx, HttpRequest request, HttpResponse response, CompletableFuture<HttpResponse> responseFuture) {
            this.ctx = ctx;
            this.request = request;
            this.responseWhenComplete = response.whenComplete();
            this.responseFuture = responseFuture;
        }

        HttpRequest request() {
            return this.request;
        }

        CompletableFuture<Void> responseWhenComplete() {
            return this.responseWhenComplete;
        }

        CompletableFuture<HttpResponse> responseFuture() {
            return this.responseFuture;
        }

        String originalUri() {
            if (this.originalUri == null) {
                this.originalUri = RedirectingClient.buildUri(this.ctx, this.request.headers());
            }
            return this.originalUri;
        }

        boolean addRedirectUri(HttpMethod method, String redirectUri) {
            if (this.redirectUris == null) {
                this.redirectUris = LinkedListMultimap.create();
            }
            return this.redirectUris.put(method, redirectUri);
        }

        Multimap<HttpMethod, String> redirectUris() {
            assert (this.redirectUris != null);
            return this.redirectUris;
        }
    }
}

