/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.Filterable;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.util.Cast;

public abstract class AbstractFilterable
extends AbstractLifeCycle
implements Filterable {
    private volatile Filter filter;
    private final Lock filterLock = new ReentrantLock();
    private final Property[] propertyArray;

    protected AbstractFilterable() {
        this(null, null);
    }

    protected AbstractFilterable(Filter filter, Property[] propertyArray) {
        this.filter = filter;
        this.propertyArray = propertyArray == null ? Property.EMPTY_ARRAY : propertyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilter(Filter filter) {
        if (filter == null) {
            return;
        }
        this.filterLock.lock();
        try {
            Filter currentFilter = this.filter;
            if (currentFilter == null) {
                this.filter = filter;
            } else if (currentFilter instanceof CompositeFilter) {
                this.filter = ((CompositeFilter)currentFilter).addFilter(filter);
            } else {
                Filter[] filters = new Filter[]{currentFilter, filter};
                this.filter = CompositeFilter.createFilters(filters);
            }
        }
        finally {
            this.filterLock.unlock();
        }
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public Property[] getPropertyArray() {
        return this.propertyArray;
    }

    @Override
    public boolean hasFilter() {
        return this.filter != null;
    }

    @Override
    public boolean isFiltered(LogEvent event) {
        return this.filter != null && this.filter.filter(event) == Filter.Result.DENY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(Filter filter) {
        if (filter == null) {
            return;
        }
        this.filterLock.lock();
        try {
            Filter currentFilter = this.filter;
            if (currentFilter == filter || filter.equals(currentFilter)) {
                this.filter = null;
            } else if (currentFilter instanceof CompositeFilter) {
                CompositeFilter composite = (CompositeFilter)currentFilter;
                this.filter = (composite = composite.removeFilter(filter)).isEmpty() ? null : (composite.size() == 1 ? composite.iterator().next() : composite);
            }
        }
        finally {
            this.filterLock.unlock();
        }
    }

    @Override
    public void start() {
        this.setStarting();
        if (this.filter != null) {
            this.filter.start();
        }
        this.setStarted();
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        return this.stop(timeout, timeUnit, true);
    }

    protected boolean stop(long timeout, TimeUnit timeUnit, boolean changeLifeCycleState) {
        if (changeLifeCycleState) {
            this.setStopping();
        }
        boolean stopped = true;
        if (this.filter != null) {
            stopped = this.filter.stop(timeout, timeUnit);
        }
        if (changeLifeCycleState) {
            this.setStopped();
        }
        return stopped;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private Filter filter;
        private Property[] propertyArray;

        public B asBuilder() {
            return (B)((Builder)Cast.cast((Object)this));
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Property[] getPropertyArray() {
            return this.propertyArray;
        }

        public B setFilter(@PluginElement Filter filter) {
            this.filter = filter;
            return this.asBuilder();
        }

        public B setPropertyArray(Property ... properties) {
            this.propertyArray = properties;
            return this.asBuilder();
        }
    }
}

