/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfigurationFactory;
import org.apache.logging.log4j.core.util.AbstractWatcher;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.core.util.internal.HttpInputStreamUtil;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertyEnvironment;

@Namespace(value="Watcher")
@Plugin(value="http")
@PluginAliases(value={"https"})
public class HttpWatcher
extends AbstractWatcher {
    private final Logger LOGGER = StatusLogger.getLogger();
    private final PropertyEnvironment properties;
    private final SslConfiguration sslConfiguration;
    private final AuthorizationProvider authorizationProvider;
    private URL url;
    private volatile long lastModifiedMillis;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    public HttpWatcher(Configuration configuration, Reconfigurable reconfigurable, List<Consumer<Reconfigurable>> configurationListeners, long lastModifiedMillis) {
        super(configuration, reconfigurable, configurationListeners);
        this.properties = configuration.getContextProperties();
        this.sslConfiguration = SslConfigurationFactory.getSslConfiguration(this.properties);
        this.authorizationProvider = AuthorizationProvider.getAuthorizationProvider(this.properties);
        this.lastModifiedMillis = lastModifiedMillis;
    }

    @Override
    public long getLastModified() {
        return this.lastModifiedMillis;
    }

    @Override
    public boolean isModified() {
        return this.refreshConfiguration();
    }

    @Override
    public void watching(Source source) {
        if (!source.getURI().getScheme().equals(HTTP) && !source.getURI().getScheme().equals(HTTPS)) {
            throw new IllegalArgumentException("HttpWatcher requires a url using the HTTP or HTTPS protocol, not " + source.getURI().getScheme());
        }
        try {
            this.url = source.getURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL for HttpWatcher " + source.getURI(), ex);
        }
        super.watching(source);
    }

    @Override
    public Watcher newWatcher(Reconfigurable reconfigurable, List<Consumer<Reconfigurable>> listeners, long lastModifiedMillis) {
        HttpWatcher watcher = new HttpWatcher(this.getConfiguration(), reconfigurable, listeners, lastModifiedMillis);
        if (this.getSource() != null) {
            watcher.watching(this.getSource());
        }
        return watcher;
    }

    private boolean refreshConfiguration() {
        try {
            LastModifiedSource source = new LastModifiedSource(this.url.toURI(), this.lastModifiedMillis);
            HttpInputStreamUtil.Result result = HttpInputStreamUtil.getInputStream(source, this.properties, this.authorizationProvider, this.sslConfiguration);
            switch (result.getStatus()) {
                case NOT_MODIFIED: {
                    this.LOGGER.debug("Configuration Not Modified");
                    return false;
                }
                case SUCCESS: {
                    ConfigurationSource configSource = this.getConfiguration().getConfigurationSource();
                    try {
                        InputStream is = result.getInputStream();
                        configSource.setData(is.readAllBytes());
                        long lastModified = source.getLastModified();
                        configSource.setModifiedMillis(lastModified);
                        this.lastModifiedMillis = lastModified;
                        this.LOGGER.debug("Content was modified for {}", (Object)this.url.toString());
                        return true;
                    }
                    catch (IOException e) {
                        this.LOGGER.error("Error accessing configuration at {}: {}", (Object)this.url, (Object)e.getMessage());
                        return false;
                    }
                }
                case NOT_FOUND: {
                    this.LOGGER.info("Unable to locate configuration at {}", (Object)this.url.toString());
                    return false;
                }
            }
            this.LOGGER.warn("Unexpected error accessing configuration at {}", (Object)this.url.toString());
            return false;
        }
        catch (URISyntaxException ex) {
            this.LOGGER.error("Bad configuration URL: {}, {}", (Object)this.url.toString(), (Object)ex.getMessage());
            return false;
        }
    }
}

