/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractAction
implements Action {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private boolean complete = false;
    private boolean interrupted = false;
    private final Lock lock = new ReentrantLock();

    protected AbstractAction() {
    }

    @Override
    public abstract boolean execute() throws IOException;

    @Override
    public void run() {
        block6: {
            this.lock.lock();
            try {
                if (this.interrupted) break block6;
                try {
                    this.execute();
                }
                catch (IOException | RuntimeException ex) {
                    this.reportException(ex);
                }
                catch (Error e) {
                    this.reportException(new RuntimeException(e));
                }
                this.complete = true;
                this.interrupted = true;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.interrupted = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    protected void reportException(Exception ex) {
        LOGGER.warn("Exception reported by action '{}'", this.getClass(), (Object)ex);
    }
}

