/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteSqlScript
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteSqlScript.class);
    private Object database;
    private Path file;

    public ExecuteSqlScript() {
    }

    public ExecuteSqlScript(Object database, Path file) {
        this.database = database;
        this.file = file;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        String script = Files.readString(this.file);
        DataSource dataSource = context.getDataSource(this.database);
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(script);
        }
        catch (SQLException e) {
            throw new WorkflowException(e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ExecuteSqlScript.class.getSimpleName() + "[", "]").add("database=" + this.database).add("file=" + this.file).toString();
    }
}

