/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.ProducesJson;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.geocoder.GeonamesQueryBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocoderResource {
    private static final Logger logger = LoggerFactory.getLogger(GeocoderResource.class);
    private final SearcherManager searcherManager;

    public GeocoderResource(SearcherManager searcherManager) {
        this.searcherManager = searcherManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Get(value="/api/geocoder")
    @ProducesJson
    public HttpResponse searchLocations(@Param(value="queryText") String queryText, @Param(value="countryCode") @Default(value="") String countryCode, @Param(value="limit") @Default(value="10") int limit) {
        if (queryText == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST);
        }
        try {
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            try {
                Query query = new GeonamesQueryBuilder().queryText(queryText).countryCode(countryCode).scoringByPopulation().andOperator().build();
                TopDocs result = searcher.search(query, limit);
                List<GeocoderResult> results = Arrays.stream(result.scoreDocs).map(scoreDoc -> this.asResult(searcher, (ScoreDoc)scoreDoc)).toList();
                ResponseHeaders headers = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", "application/json").add((CharSequence)"Access-Control-Allow-Origin", "*").build();
                HttpResponse httpResponse = HttpResponse.ofJson((ResponseHeaders)headers, (Object)new GeocoderResponse(results));
                return httpResponse;
            }
            catch (IllegalArgumentException e) {
                logger.warn("Illegal input while processing request", (Throwable)e);
                HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST);
                return httpResponse;
            }
            catch (IOException | ParseException e) {
                logger.error("Error while processing request", (Throwable)e);
                HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
                return httpResponse;
            }
            finally {
                this.searcherManager.release((Object)searcher);
            }
        }
        catch (Exception e) {
            logger.error("Error while processing request", (Throwable)e);
            return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private GeocoderResult asResult(IndexSearcher indexSearcher, ScoreDoc scoreDoc) {
        try {
            Document document = indexSearcher.doc(scoreDoc.doc);
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (IndexableField field : document.getFields()) {
                if (field.numericValue() != null) {
                    data.put(field.name(), field.numericValue());
                    continue;
                }
                if (field.stringValue() == null) continue;
                data.put(field.name(), field.stringValue());
            }
            return new GeocoderResult(scoreDoc.score, data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    record GeocoderResponse(List<GeocoderResult> results) {
    }

    record GeocoderResult(float score, Map<String, Object> data) {
    }
}

