/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.BlockingIterables;
import io.servicetalk.encoding.api.BufferEncoderDecoder;
import io.servicetalk.oio.api.PayloadWriter;
import io.servicetalk.serializer.api.Deserializer;
import io.servicetalk.serializer.api.Serializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingDeserializer;
import io.servicetalk.serializer.api.StreamingSerializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;

final class IdentityBufferEncoderDecoder
implements BufferEncoderDecoder {
    private static final CharSequence IDENTITY_NAME = CharSequences.newAsciiString((CharSequence)"identity");
    private static final int HASH_CODE = CharSequences.caseInsensitiveHashCode((CharSequence)IDENTITY_NAME);
    static final BufferEncoderDecoder INSTANCE = new IdentityBufferEncoderDecoder();

    private IdentityBufferEncoderDecoder() {
    }

    @Override
    public Deserializer<Buffer> decoder() {
        return NoopBufferSerializer.INSTANCE;
    }

    @Override
    public StreamingDeserializer<Buffer> streamingDecoder() {
        return NoopStreamingBufferSerializer.INSTANCE;
    }

    @Override
    public Serializer<Buffer> encoder() {
        return NoopBufferSerializer.INSTANCE;
    }

    @Override
    public StreamingSerializer<Buffer> streamingEncoder() {
        return NoopStreamingBufferSerializer.INSTANCE;
    }

    @Override
    public CharSequence encodingName() {
        return IDENTITY_NAME;
    }

    public String toString() {
        return IDENTITY_NAME.toString();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BufferEncoderDecoder && CharSequences.contentEqualsIgnoreCase((CharSequence)this.encodingName(), (CharSequence)((BufferEncoderDecoder)o).encodingName());
    }

    public int hashCode() {
        return HASH_CODE;
    }

    private static final class NoopStreamingBufferSerializer
    implements StreamingSerializerDeserializer<Buffer> {
        private static final StreamingSerializerDeserializer<Buffer> INSTANCE = new NoopStreamingBufferSerializer();

        private NoopStreamingBufferSerializer() {
        }

        public Publisher<Buffer> deserialize(Publisher<Buffer> serializedData, BufferAllocator allocator) {
            return serializedData;
        }

        public BlockingIterable<Buffer> deserialize(Iterable<Buffer> serializedData, BufferAllocator allocator) {
            return BlockingIterables.from(serializedData);
        }

        public Publisher<Buffer> serialize(Publisher<Buffer> toSerialize, BufferAllocator allocator) {
            return toSerialize;
        }

        public BlockingIterable<Buffer> serialize(Iterable<Buffer> toSerialize, BufferAllocator allocator) {
            return BlockingIterables.from(toSerialize);
        }

        public PayloadWriter<Buffer> serialize(PayloadWriter<Buffer> writer, BufferAllocator allocator) {
            return writer;
        }

        public String toString() {
            return IDENTITY_NAME.toString();
        }
    }

    private static final class NoopBufferSerializer
    implements SerializerDeserializer<Buffer> {
        private static final SerializerDeserializer<Buffer> INSTANCE = new NoopBufferSerializer();

        private NoopBufferSerializer() {
        }

        public Buffer deserialize(Buffer serializedData, BufferAllocator allocator) {
            return serializedData;
        }

        public void serialize(Buffer toSerialize, BufferAllocator allocator, Buffer buffer) {
            if (toSerialize != buffer) {
                buffer.writeBytes(toSerialize);
            }
        }

        public Buffer serialize(Buffer toSerialize, BufferAllocator allocator) {
            return toSerialize;
        }

        public String toString() {
            return IDENTITY_NAME.toString();
        }
    }
}

