/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.ConditionalHttpClientFilter;
import io.servicetalk.http.netty.ConditionalHttpConnectionFilter;
import io.servicetalk.http.netty.ConditionalHttpServiceFilter;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.RetryingHttpRequesterFilter;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class StrategyInfluencerAwareConversions {
    private StrategyInfluencerAwareConversions() {
    }

    static StreamingHttpServiceFilterFactory toConditionalServiceFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpServiceFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        return new StreamingHttpServiceFilterFactory(){

            public StreamingHttpServiceFilter create(StreamingHttpService service) {
                return new ConditionalHttpServiceFilter(predicate, original.create(service), service);
            }

            public HttpExecutionStrategy requiredOffloads() {
                return original.requiredOffloads();
            }
        };
    }

    static StreamingHttpConnectionFilterFactory toConditionalConnectionFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpConnectionFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        return new StreamingHttpConnectionFilterFactory(){

            public HttpExecutionStrategy requiredOffloads() {
                return original.requiredOffloads();
            }

            public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
                return new ConditionalHttpConnectionFilter(predicate, (FilterableStreamingHttpConnection)original.create(connection), connection);
            }
        };
    }

    static DefaultSingleAddressHttpClientBuilder.ContextAwareStreamingHttpClientFilterFactory toConditionalClientFilterFactory(final Predicate<StreamingHttpRequest> predicate, final StreamingHttpClientFilterFactory original) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(original);
        return new DefaultSingleAddressHttpClientBuilder.ContextAwareStreamingHttpClientFilterFactory(){

            public HttpExecutionStrategy requiredOffloads() {
                return original.requiredOffloads();
            }

            @Override
            public StreamingHttpClientFilter create(FilterableStreamingHttpClient client, @Nullable Publisher<Object> lbEventStream, @Nullable Completable sdStatus) {
                if (original instanceof RetryingHttpRequesterFilter) {
                    RetryingHttpRequesterFilter.ContextAwareRetryingHttpClientFilter filter = (RetryingHttpRequesterFilter.ContextAwareRetryingHttpClientFilter)original.create(client);
                    filter.inject(lbEventStream, sdStatus);
                    return new ConditionalHttpClientFilter(predicate, (FilterableStreamingHttpClient)filter, client);
                }
                return new ConditionalHttpClientFilter(predicate, (FilterableStreamingHttpClient)original.create(client), client);
            }
        };
    }
}

