/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.router.utils.internal;

import io.servicetalk.router.api.NoOffloadsRouteExecutionStrategy;
import io.servicetalk.router.api.RouteExecutionStrategy;
import io.servicetalk.router.api.RouteExecutionStrategyFactory;
import io.servicetalk.transport.api.ExecutionStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class RouteExecutionStrategyUtils {
    private RouteExecutionStrategyUtils() {
    }

    @Nullable
    public static Annotation validateRouteExecutionStrategyAnnotationIfPresent(Method method, Class<?> clazz, RouteExecutionStrategyFactory<? extends ExecutionStrategy> strategyFactory, Set<String> errors) {
        Annotation annotation = RouteExecutionStrategyUtils.validateAnnotation(method, clazz, errors);
        if (annotation == null) {
            return null;
        }
        if (annotation instanceof NoOffloadsRouteExecutionStrategy) {
            return annotation;
        }
        RouteExecutionStrategyUtils.validateId(annotation, method, strategyFactory, errors);
        return annotation;
    }

    @Nullable
    public static <T extends ExecutionStrategy> T getAndValidateRouteExecutionStrategyAnnotationIfPresent(Method method, Class<?> clazz, RouteExecutionStrategyFactory<T> strategyFactory, Set<String> errors, T noOffloadsExecutionStrategy) {
        Annotation annotation = RouteExecutionStrategyUtils.validateAnnotation(method, clazz, errors);
        if (annotation == null) {
            return null;
        }
        if (annotation instanceof NoOffloadsRouteExecutionStrategy) {
            return noOffloadsExecutionStrategy;
        }
        return RouteExecutionStrategyUtils.validateId(annotation, method, strategyFactory, errors);
    }

    @Nullable
    private static Annotation validateAnnotation(Method method, Class<?> clazz, Set<String> errors) {
        Annotation annotation;
        if (Arrays.stream(method.getAnnotations()).filter(RouteExecutionStrategyUtils::isRouteExecutionStrategyAnnotation).count() > 1L) {
            errors.add("More than one execution strategy annotation found on method: " + method);
            annotation = null;
        } else if (Arrays.stream(clazz.getAnnotations()).filter(RouteExecutionStrategyUtils::isRouteExecutionStrategyAnnotation).count() > 1L) {
            errors.add("More than one execution strategy annotation found on: " + clazz);
            annotation = null;
        } else {
            annotation = RouteExecutionStrategyUtils.getRouteExecutionStrategyAnnotation(method, clazz);
        }
        return annotation;
    }

    @Nullable
    private static <T extends ExecutionStrategy> T validateId(Annotation annotation, Method method, RouteExecutionStrategyFactory<T> strategyFactory, Set<String> errors) {
        String id = ((RouteExecutionStrategy)annotation).id();
        if (id.isEmpty()) {
            errors.add("Route execution strategy with empty ID specified on: " + method);
            return null;
        }
        try {
            return (T)((ExecutionStrategy)Objects.requireNonNull(strategyFactory.get(id)));
        }
        catch (Exception e) {
            errors.add("Failed to create an execution strategy for ID \"" + id + "\" specified on: " + method + ".\n" + e.getClass() + ": " + e.getMessage() + (e.getCause() != null ? "\nCaused by: " + e.getCause().getClass() + ": " + e.getCause().getMessage() : ""));
            return null;
        }
    }

    @Nullable
    public static Annotation getRouteExecutionStrategyAnnotation(Method method, Class<?> clazz) {
        NoOffloadsRouteExecutionStrategy annotation = method.getAnnotation(NoOffloadsRouteExecutionStrategy.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = method.getAnnotation(RouteExecutionStrategy.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = clazz.getAnnotation(NoOffloadsRouteExecutionStrategy.class);
        if (annotation != null) {
            return annotation;
        }
        return clazz.getAnnotation(RouteExecutionStrategy.class);
    }

    private static boolean isRouteExecutionStrategyAnnotation(Annotation annotation) {
        return annotation instanceof NoOffloadsRouteExecutionStrategy || annotation instanceof RouteExecutionStrategy;
    }
}

