/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.common;

import java.util.logging.Logger;
import mil.nga.crs.common.DateTime;
import mil.nga.crs.wkt.CRSWriter;

public class TemporalExtent {
    private static final Logger logger = Logger.getLogger(TemporalExtent.class.getName());
    private String start = null;
    private DateTime startDateTime = null;
    private String end = null;
    private DateTime endDateTime = null;

    public TemporalExtent() {
    }

    public TemporalExtent(String start, String end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public TemporalExtent(DateTime start, DateTime end) {
        this.setStartDateTime(start);
        this.setEndDateTime(end);
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
        DateTime dateTime = DateTime.tryParse(start);
        if (dateTime != null) {
            this.startDateTime = dateTime;
        }
    }

    public DateTime getStartDateTime() {
        return this.startDateTime;
    }

    public boolean hasStartDateTime() {
        return this.getStartDateTime() != null;
    }

    public void setStartDateTime(DateTime startDateTime) {
        this.startDateTime = startDateTime;
        this.start = startDateTime.toString();
    }

    public void setStartDateTime(String start) {
        this.start = start;
        this.startDateTime = DateTime.parse(start);
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
        DateTime dateTime = DateTime.tryParse(end);
        if (dateTime != null) {
            this.endDateTime = dateTime;
        }
    }

    public DateTime getEndDateTime() {
        return this.endDateTime;
    }

    public boolean hasEndDateTime() {
        return this.getEndDateTime() != null;
    }

    public void setEndDateTime(DateTime endDateTime) {
        this.endDateTime = endDateTime;
        this.end = endDateTime.toString();
    }

    public void setEndDateTime(String end) {
        this.end = end;
        this.endDateTime = DateTime.parse(end);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.endDateTime == null ? 0 : this.endDateTime.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.startDateTime == null ? 0 : this.startDateTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporalExtent other = (TemporalExtent)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.endDateTime == null ? other.endDateTime != null : !this.endDateTime.equals(other.endDateTime)) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        return !(this.startDateTime == null ? other.startDateTime != null : !this.startDateTime.equals(other.startDateTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

