/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.baremaps.database.collection.AppendOnlyBuffer;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.database.collection.MemoryAlignedDataList;
import org.apache.baremaps.database.collection.MemoryAlignedDataMap;
import org.apache.baremaps.database.collection.MonotonicDataMap;
import org.apache.baremaps.database.memory.MemoryMappedDirectory;
import org.apache.baremaps.database.type.LongDataType;
import org.apache.baremaps.database.type.LongListDataType;
import org.apache.baremaps.database.type.PairDataType;
import org.apache.baremaps.database.type.geometry.LonLatDataType;
import org.apache.baremaps.geocoder.GeocoderConstants;
import org.apache.baremaps.geocoderosm.GeocoderOsmConsumerEntity;
import org.apache.baremaps.openstreetmap.pbf.PbfEntityReader;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.stream.StreamUtils;
import org.apache.baremaps.utils.FileUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CreateGeocoderOpenStreetMap(Path file, Path indexDirectory) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(CreateGeocoderOpenStreetMap.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataMap coordinateMap;
        Path path = this.file.toAbsolutePath();
        Path cacheDir = Files.createTempDirectory(Paths.get(".", new String[0]), "cache_", new FileAttribute[0]);
        if (Files.size(path) > 0x40000000L) {
            Path coordinateDir = Files.createDirectories(cacheDir.resolve("coordinate_keys"), new FileAttribute[0]);
            coordinateMap = new MemoryAlignedDataMap<Coordinate>(new LonLatDataType(), new MemoryMappedDirectory(coordinateDir));
        } else {
            Path coordinateKeysDir = Files.createDirectories(cacheDir.resolve("coordinate_keys"), new FileAttribute[0]);
            Path coordinateValuesDir = Files.createDirectories(cacheDir.resolve("coordinate_vals"), new FileAttribute[0]);
            coordinateMap = new MonotonicDataMap<Coordinate>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedDirectory(coordinateKeysDir)), new AppendOnlyBuffer<Coordinate>(new LonLatDataType(), new MemoryMappedDirectory(coordinateValuesDir)));
        }
        Path referenceKeysDir = Files.createDirectory(cacheDir.resolve("reference_keys"), new FileAttribute[0]);
        Path referenceValuesDir = Files.createDirectory(cacheDir.resolve("reference_vals"), new FileAttribute[0]);
        MonotonicDataMap<List<Long>> referenceMap = new MonotonicDataMap<List<Long>>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedDirectory(referenceKeysDir)), new AppendOnlyBuffer<List<Long>>(new LongListDataType(), new MemoryMappedDirectory(referenceValuesDir)));
        FSDirectory directory = FSDirectory.open((Path)this.indexDirectory);
        IndexWriterConfig config = new IndexWriterConfig(GeocoderConstants.ANALYZER);
        try (IndexWriter indexWriter = new IndexWriter((Directory)directory, config);){
            GeocoderOsmConsumerEntity importer = new GeocoderOsmConsumerEntity(indexWriter);
            CreateGeocoderOpenStreetMap.execute(path, coordinateMap, referenceMap, importer);
        }
        FileUtils.deleteRecursively(cacheDir);
    }

    public static void execute(Path path, DataMap<Long, Coordinate> coordinateMap, DataMap<Long, List<Long>> referenceMap, GeocoderOsmConsumerEntity importer) throws IOException {
        PbfReader reader = ((PbfEntityReader)new PbfEntityReader().geometries(true).projection(4326).coordinateMap((DataMap)coordinateMap)).referenceMap((DataMap)referenceMap);
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            StreamUtils.batch(((PbfEntityReader)reader).stream(input)).forEach(importer);
        }
    }
}

