/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.util.concurrent.FastThreadLocal;
import io.servicetalk.transport.api.DelegatingExecutionContext;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.IoExecutor;
import io.servicetalk.transport.netty.internal.NettyIoExecutors;

public final class ExecutionContextUtils {
    private static final FastThreadLocal<IoExecutor> CHANNEL_IO_EXECUTOR = new FastThreadLocal();

    private ExecutionContextUtils() {
    }

    public static IoExecutor fromChannel(Channel channel, boolean isIoThreadSupported) {
        assert (channel.eventLoop().inEventLoop());
        IoExecutor ioExecutor = (IoExecutor)CHANNEL_IO_EXECUTOR.getIfExists();
        if (ioExecutor != null) {
            return ioExecutor;
        }
        ioExecutor = NettyIoExecutors.fromNettyEventLoop(channel.eventLoop(), isIoThreadSupported);
        CHANNEL_IO_EXECUTOR.set((Object)ioExecutor);
        return ioExecutor;
    }

    public static <ES extends ExecutionStrategy> ExecutionContext<ES> channelExecutionContext(Channel channel, ExecutionContext<ES> builderExecutionContext) {
        final IoExecutor channelIoExecutor = ExecutionContextUtils.fromChannel(channel, builderExecutionContext.ioExecutor().isIoThreadSupported());
        return new DelegatingExecutionContext<ES>(builderExecutionContext){

            public IoExecutor ioExecutor() {
                return channelIoExecutor;
            }
        };
    }

    public static void clearThreadLocal() {
        CHANNEL_IO_EXECUTOR.remove();
    }
}

