package org.apache.baremaps.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.baremaps.model.Extent;
import org.apache.baremaps.model.Link;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-03-14T17:37:24.176539752Z[Etc/UTC]")public class Collection   {
  
  private @Valid UUID id;
  private @Valid String title;
  private @Valid String description;
  private @Valid String attribution;
  private @Valid List<Link> links = new ArrayList<Link>();
  private @Valid Extent extent;
  private @Valid String itemType;
  private @Valid List<String> crs = new ArrayList<String>();
  private @Valid Date created;
  private @Valid Integer count;
  private @Valid String geometryType;

  /**
   **/
  public Collection id(UUID id) {
    this.id = id;
    return this;
  }

  

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("id")
  @NotNull
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }/**
   **/
  public Collection title(String title) {
    this.title = title;
    return this;
  }

  

  
  @ApiModelProperty(example = "address", value = "")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }/**
   **/
  public Collection description(String description) {
    this.description = description;
    return this;
  }

  

  
  @ApiModelProperty(example = "An address", value = "")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }/**
   **/
  public Collection attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }/**
   **/
  public Collection links(List<Link> links) {
    this.links = links;
    return this;
  }

  

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("links")
  @NotNull
  public List<Link> getLinks() {
    return links;
  }

  public void setLinks(List<Link> links) {
    this.links = links;
  }/**
   **/
  public Collection extent(Extent extent) {
    this.extent = extent;
    return this;
  }

  

  
  @ApiModelProperty(value = "")
  @JsonProperty("extent")
  public Extent getExtent() {
    return extent;
  }

  public void setExtent(Extent extent) {
    this.extent = extent;
  }/**
   * An indicator about the type of the items in the collection
   **/
  public Collection itemType(String itemType) {
    this.itemType = itemType;
    return this;
  }

  

  
  @ApiModelProperty(value = "An indicator about the type of the items in the collection")
  @JsonProperty("itemType")
  public String getItemType() {
    return itemType;
  }

  public void setItemType(String itemType) {
    this.itemType = itemType;
  }/**
   * the list of coordinate reference systems supported by the API; the first item is the default coordinate reference system
   **/
  public Collection crs(List<String> crs) {
    this.crs = crs;
    return this;
  }

  

  
  @ApiModelProperty(example = "[http://www.opengis.net/def/crs/OGC/1.3/CRS84, http://www.opengis.net/def/crs/EPSG/0/4326]", value = "the list of coordinate reference systems supported by the API; the first item is the default coordinate reference system")
  @JsonProperty("crs")
  public List<String> getCrs() {
    return crs;
  }

  public void setCrs(List<String> crs) {
    this.crs = crs;
  }/**
   * Date of creation
   **/
  public Collection created(Date created) {
    this.created = created;
    return this;
  }

  

  
  @ApiModelProperty(value = "Date of creation")
  @JsonProperty("created")
  public Date getCreated() {
    return created;
  }

  public void setCreated(Date created) {
    this.created = created;
  }/**
   * Feature count
   **/
  public Collection count(Integer count) {
    this.count = count;
    return this;
  }

  

  
  @ApiModelProperty(value = "Feature count")
  @JsonProperty("count")
  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }/**
   * Geometry type of the features
   **/
  public Collection geometryType(String geometryType) {
    this.geometryType = geometryType;
    return this;
  }

  

  
  @ApiModelProperty(value = "Geometry type of the features")
  @JsonProperty("geometryType")
  public String getGeometryType() {
    return geometryType;
  }

  public void setGeometryType(String geometryType) {
    this.geometryType = geometryType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Collection collection = (Collection) o;
    return Objects.equals(this.id, collection.id) &&
        Objects.equals(this.title, collection.title) &&
        Objects.equals(this.description, collection.description) &&
        Objects.equals(this.attribution, collection.attribution) &&
        Objects.equals(this.links, collection.links) &&
        Objects.equals(this.extent, collection.extent) &&
        Objects.equals(this.itemType, collection.itemType) &&
        Objects.equals(this.crs, collection.crs) &&
        Objects.equals(this.created, collection.created) &&
        Objects.equals(this.count, collection.count) &&
        Objects.equals(this.geometryType, collection.geometryType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, description, attribution, links, extent, itemType, crs, created, count, geometryType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Collection {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    extent: ").append(toIndentedString(extent)).append("\n");
    sb.append("    itemType: ").append(toIndentedString(itemType)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    geometryType: ").append(toIndentedString(geometryType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

