/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import javax.sql.DataSource;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.database.ChangeImporter;
import org.apache.baremaps.database.collection.PostgresCoordinateMap;
import org.apache.baremaps.database.collection.PostgresReferenceMap;
import org.apache.baremaps.database.repository.HeaderRepository;
import org.apache.baremaps.database.repository.PostgresHeaderRepository;
import org.apache.baremaps.database.repository.PostgresNodeRepository;
import org.apache.baremaps.database.repository.PostgresRelationRepository;
import org.apache.baremaps.database.repository.PostgresWayRepository;
import org.apache.baremaps.database.repository.Repository;
import org.apache.baremaps.openstreetmap.function.ChangeEntitiesHandler;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.State;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.state.StateReader;
import org.apache.baremaps.openstreetmap.xml.XmlChangeReader;
import org.apache.baremaps.stream.ConsumerUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record UpdateOpenStreetMap(String database, Integer databaseSrid) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(UpdateOpenStreetMap.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Updating {}", (Object)this.database);
        DataSource datasource = context.getDataSource(this.database);
        PostgresCoordinateMap coordinateMap = new PostgresCoordinateMap(datasource);
        PostgresReferenceMap referenceMap = new PostgresReferenceMap(datasource);
        PostgresHeaderRepository headerRepository = new PostgresHeaderRepository(datasource);
        PostgresNodeRepository nodeRepository = new PostgresNodeRepository(datasource);
        PostgresWayRepository wayRepository = new PostgresWayRepository(datasource);
        PostgresRelationRepository relationRepository = new PostgresRelationRepository(datasource);
        UpdateOpenStreetMap.execute(coordinateMap, referenceMap, headerRepository, nodeRepository, wayRepository, relationRepository, this.databaseSrid);
        logger.info("Finished updating {}", (Object)this.database);
    }

    public static void execute(DataMap<Coordinate> coordinateMap, DataMap<List<Long>> referenceMap, HeaderRepository headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository, int srid) throws Exception {
        Header header = headerRepository.selectLatest();
        String replicationUrl = header.getReplicationUrl();
        long sequenceNumber = header.getReplicationSequenceNumber() + 1L;
        EntityGeometryBuilder createGeometry = new EntityGeometryBuilder(coordinateMap, referenceMap);
        EntityProjectionTransformer reprojectGeometry = new EntityProjectionTransformer(4326, srid);
        ChangeEntitiesHandler prepareGeometries = new ChangeEntitiesHandler(createGeometry.andThen(reprojectGeometry));
        Function<Change, Change> prepareChange = ConsumerUtils.consumeThenReturn(prepareGeometries);
        ChangeImporter saveChange = new ChangeImporter(nodeRepository, wayRepository, relationRepository);
        URL changeUrl = UpdateOpenStreetMap.resolve(replicationUrl, sequenceNumber, "osc.gz");
        try (GZIPInputStream changeInputStream = new GZIPInputStream(new BufferedInputStream(changeUrl.openStream()));){
            new XmlChangeReader().stream(changeInputStream).map(prepareChange).forEach(saveChange);
        }
        URL stateUrl = UpdateOpenStreetMap.resolve(replicationUrl, sequenceNumber, "state.txt");
        try (BufferedInputStream stateInputStream = new BufferedInputStream(stateUrl.openStream());){
            State state = new StateReader().state(stateInputStream);
            headerRepository.put(new Header(state.getSequenceNumber(), state.getTimestamp(), header.getReplicationUrl(), header.getSource(), header.getWritingProgram()));
        }
    }

    public static URL resolve(String replicationUrl, Long sequenceNumber, String extension) throws MalformedURLException {
        String s = String.format("%09d", sequenceNumber);
        String uri = String.format("%s/%s/%s/%s.%s", replicationUrl, s.substring(0, 3), s.substring(3, 6), s.substring(6, 9), extension);
        return URI.create(uri).toURL();
    }
}

