/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Path;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.utils.ProjectionTransformer;
import org.apache.baremaps.storage.FeatureSetProjectionTransform;
import org.apache.baremaps.storage.postgres.PostgresDatabase;
import org.apache.baremaps.storage.shapefile.ShapefileFeatureSet;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ImportShapefile(Path file, String database, Integer sourceSRID, Integer targetSRID) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ImportShapefile.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Importing {} into {}", (Object)this.file, (Object)this.database);
        Path path = this.file.toAbsolutePath();
        try (ShapefileFeatureSet featureSet = new ShapefileFeatureSet(path);){
            DataSource dataSource = context.getDataSource(this.database);
            PostgresDatabase postgresDatabase = new PostgresDatabase(dataSource);
            postgresDatabase.write(new FeatureSetProjectionTransform(featureSet, new ProjectionTransformer(this.sourceSRID, this.targetSRID)));
            logger.info("Finished importing {} into {}", (Object)this.file, (Object)this.database);
        }
        catch (Exception e) {
            logger.error("Failed importing {} into {}", (Object)this.file, (Object)this.database);
            throw new WorkflowException(e);
        }
    }
}

