/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.List;
import java.util.function.Consumer;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.openstreetmap.function.NodeGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.RelationGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.WayGeometryBuilder;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.locationtech.jts.geom.Coordinate;

public class EntityGeometryBuilder
implements Consumer<Entity> {
    private final NodeGeometryBuilder nodeGeometryBuilder = new NodeGeometryBuilder();
    private final WayGeometryBuilder wayGeometryBuilder;
    private final RelationGeometryBuilder relationGeometryBuilder;

    public EntityGeometryBuilder(DataMap<Coordinate> coordinateMap, DataMap<List<Long>> referenceMap) {
        this.wayGeometryBuilder = new WayGeometryBuilder(coordinateMap);
        this.relationGeometryBuilder = new RelationGeometryBuilder(coordinateMap, referenceMap);
    }

    @Override
    public void accept(Entity entity) {
        if (entity instanceof Node) {
            Node node = (Node)entity;
            this.nodeGeometryBuilder.accept(node);
        } else if (entity instanceof Way) {
            Way way = (Way)entity;
            this.wayGeometryBuilder.accept(way);
        } else if (entity instanceof Relation) {
            Relation relation = (Relation)entity;
            this.relationGeometryBuilder.accept(relation);
        }
    }
}

