/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.baremaps.iploc.data.InetnumLocation;
import org.apache.baremaps.iploc.data.Ipv4Range;
import org.apache.baremaps.iploc.data.Location;
import org.apache.baremaps.iploc.database.InetnumLocationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;

public final class InetnumLocationDaoSqliteImpl
implements InetnumLocationDao {
    private static final String INSERT_SQL = "INSERT INTO inetnum_locations(address, ip_start, ip_end, latitude, longitude, network, country)\nVALUES(?,?,?,?,?,?,?)";
    private static final String SELECT_ALL_SQL = "SELECT id, address, ip_start, ip_end, latitude, longitude, network, country\nFROM inetnum_locations;";
    private static final String SELECT_ALL_BY_IP_SQL = "SELECT id, address, ip_start, ip_end, latitude, longitude, network, country\nFROM inetnum_locations\nWHERE ip_start <= ? AND ip_end >= ?\nORDER BY ip_start DESC, ip_end ASC;";
    private static final Logger logger = LoggerFactory.getLogger(InetnumLocationDaoSqliteImpl.class);
    private final HikariDataSource readDatasource;
    private final SQLiteDataSource writeDatasource;

    public InetnumLocationDaoSqliteImpl(String url) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.readDatasource = new HikariDataSource(config);
        config = new SQLiteConfig();
        this.writeDatasource = new SQLiteDataSource((SQLiteConfig)config);
        this.writeDatasource.setUrl(url);
    }

    public Connection getReadConnection() throws SQLException {
        return this.readDatasource.getConnection();
    }

    public Connection getWriteConnection() throws SQLException {
        return this.writeDatasource.getConnection();
    }

    @Override
    public Optional<InetnumLocation> findOne(long id) {
        return Optional.empty();
    }

    @Override
    public List<InetnumLocation> findAll() {
        ArrayList<InetnumLocation> results = new ArrayList<InetnumLocation>();
        try (Connection connection = this.getReadConnection();
             PreparedStatement stmt = connection.prepareStatement(SELECT_ALL_SQL);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                results.add(new InetnumLocation(rs.getString("address"), new Ipv4Range(rs.getBytes("ip_start"), rs.getBytes("ip_end")), new Location(rs.getDouble("latitude"), rs.getDouble("longitude")), rs.getString("network"), rs.getString("country")));
            }
        }
        catch (SQLException e) {
            logger.error("Unable to select inetnum locations", (Throwable)e);
        }
        return results;
    }

    @Override
    public List<InetnumLocation> findByIp(byte[] ip) {
        ArrayList<InetnumLocation> results = new ArrayList<InetnumLocation>();
        try (Connection connection = this.getReadConnection();
             PreparedStatement stmt = connection.prepareStatement(SELECT_ALL_BY_IP_SQL);){
            stmt.setBytes(1, ip);
            stmt.setBytes(2, ip);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    results.add(new InetnumLocation(rs.getString("address"), new Ipv4Range(rs.getBytes("ip_start"), rs.getBytes("ip_end")), new Location(rs.getDouble("latitude"), rs.getDouble("longitude")), rs.getString("network"), rs.getString("country")));
                }
            }
        }
        catch (SQLException e) {
            logger.error("Unable to select inetnum locations", (Throwable)e);
        }
        return results;
    }

    @Override
    public void save(InetnumLocation inetnumLocation) {
        try (Connection connection = this.getWriteConnection();
             PreparedStatement stmt = connection.prepareStatement(INSERT_SQL);){
            stmt.setString(1, inetnumLocation.getAddress());
            stmt.setBytes(2, inetnumLocation.getIpv4Range().getStart());
            stmt.setBytes(3, inetnumLocation.getIpv4Range().getEnd());
            stmt.setDouble(4, inetnumLocation.getLocation().getLatitude());
            stmt.setDouble(5, inetnumLocation.getLocation().getLongitude());
            stmt.setString(6, inetnumLocation.getNetwork());
            stmt.setString(7, inetnumLocation.getCountry());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            logger.error("Unable to save data", (Throwable)e);
        }
    }

    @Override
    public void save(List<InetnumLocation> inetnumLocations) {
        try (Connection connection = this.getWriteConnection();
             PreparedStatement stmt = connection.prepareStatement(INSERT_SQL);){
            connection.setAutoCommit(false);
            for (InetnumLocation inetnumLocation : inetnumLocations) {
                stmt.setString(1, inetnumLocation.getAddress());
                stmt.setBytes(2, inetnumLocation.getIpv4Range().getStart());
                stmt.setBytes(3, inetnumLocation.getIpv4Range().getEnd());
                stmt.setDouble(4, inetnumLocation.getLocation().getLatitude());
                stmt.setDouble(5, inetnumLocation.getLocation().getLongitude());
                stmt.setString(6, inetnumLocation.getNetwork());
                stmt.setString(7, inetnumLocation.getCountry());
                stmt.addBatch();
            }
            stmt.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            logger.error("Unable to save data", (Throwable)e);
        }
    }

    @Override
    public void update(InetnumLocation inetnumLocation, String[] params) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void delete(InetnumLocation inetnumLocation) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

