/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder;

import java.util.function.Function;
import org.apache.baremaps.geocoder.GeonamesRecord;
import org.apache.baremaps.geocoder.IsoCountriesUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class GeonamesDocumentMapper
implements Function<GeonamesRecord, Document> {
    @Override
    public Document apply(GeonamesRecord record) {
        Document document = new Document();
        document.add((IndexableField)new TextField("name", record.getName(), Field.Store.YES));
        document.add((IndexableField)new TextField("country", IsoCountriesUtils.getCountry(record.getCountryCode()), Field.Store.YES));
        document.add((IndexableField)new StringField("countryCode", record.getCountryCode(), Field.Store.YES));
        document.add((IndexableField)new LatLonPoint("point", record.getLatitude().doubleValue(), record.getLongitude().doubleValue()));
        document.add((IndexableField)new StoredField("longitude", record.getLongitude().doubleValue()));
        document.add((IndexableField)new StoredField("latitude", record.getLatitude().doubleValue()));
        document.add((IndexableField)new StoredField("asciiname", record.getAsciiname()));
        document.add((IndexableField)new StoredField("alternatenames", record.getAlternatenames()));
        document.add((IndexableField)new StoredField("featureClass", record.getFeatureClass()));
        document.add((IndexableField)new StoredField("featureCode", record.getFeatureCode()));
        document.add((IndexableField)new StoredField("cc2", record.getCc2()));
        document.add((IndexableField)new StoredField("admin1Code", record.getAdmin1Code()));
        document.add((IndexableField)new StoredField("admin2Code", record.getAdmin2Code()));
        document.add((IndexableField)new StoredField("admin3Code", record.getAdmin3Code()));
        document.add((IndexableField)new StoredField("admin4Code", record.getAdmin4Code()));
        document.add((IndexableField)new StoredField("population", record.getPopulation().longValue()));
        if (record.getElevation() != null) {
            document.add((IndexableField)new StoredField("elevation", record.getElevation().intValue()));
        }
        document.add((IndexableField)new StoredField("dem", record.getDem().intValue()));
        document.add((IndexableField)new StoredField("timezone", record.getTimezone()));
        document.add((IndexableField)new StoredField("modificationDate", record.getModificationDate()));
        return document;
    }
}

