/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mil.nga.crs.common.Identifiable;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.common.Unit;
import mil.nga.crs.operation.OperationParameters;
import mil.nga.crs.wkt.CRSWriter;

public class OperationParameter
implements Identifiable {
    private static final Logger logger = Logger.getLogger(OperationParameter.class.getName());
    private String name = null;
    private double value;
    private String valueText;
    private Unit unit;
    private String fileName = null;
    private List<Identifier> identifiers = null;
    private OperationParameters parameter;

    public OperationParameter() {
    }

    public OperationParameter(String name, double value) {
        this(name, value, null);
    }

    public OperationParameter(String name, double value, Unit unit) {
        this.name = name;
        this.setValue(value);
        this.unit = unit;
        this.updateParameter();
    }

    public OperationParameter(String name, String value, Unit unit) {
        this.name = name;
        this.setValue(value);
        this.unit = unit;
        this.updateParameter();
    }

    public OperationParameter(OperationParameters parameter, double value) {
        this(parameter, value, null);
    }

    public OperationParameter(OperationParameters parameter, String value) {
        this(parameter, value, null);
    }

    public OperationParameter(OperationParameters parameter, double value, Unit unit) {
        this.name = parameter.getName();
        this.setValue(value);
        this.unit = unit;
        this.parameter = parameter;
    }

    public OperationParameter(OperationParameters parameter, String value, Unit unit) {
        this.name = parameter.getName();
        this.setValue(value);
        this.unit = unit;
        this.parameter = parameter;
    }

    public OperationParameter(String name, String fileName) {
        this.name = name;
        this.fileName = fileName;
        this.updateParameter();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.updateParameter();
    }

    public double getValue() {
        return this.value;
    }

    public String getValueText() {
        return this.valueText;
    }

    public void setValue(double value) {
        this.value = value;
        this.valueText = String.valueOf(value);
    }

    public void setValue(String value) {
        this.valueText = value;
        this.value = Double.parseDouble(value);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean hasUnit() {
        return this.getUnit() != null;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFile() {
        return this.getFileName() != null;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public boolean hasIdentifiers() {
        return this.identifiers != null && !this.identifiers.isEmpty();
    }

    @Override
    public int numIdentifiers() {
        return this.identifiers != null ? this.identifiers.size() : 0;
    }

    @Override
    public Identifier getIdentifier(int index) {
        return this.identifiers.get(index);
    }

    @Override
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    @Override
    public void addIdentifiers(List<Identifier> identifiers) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.addAll(identifiers);
    }

    public OperationParameters getParameter() {
        return this.parameter;
    }

    public boolean hasParameter() {
        return this.getParameter() != null;
    }

    public void setParameter(OperationParameters parameter) {
        this.parameter = parameter;
    }

    public void updateParameter() {
        this.setParameter(OperationParameters.getParameter(this.getName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.identifiers == null ? 0 : this.identifiers.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationParameter other = (OperationParameter)obj;
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.identifiers == null ? other.identifiers != null : !this.identifiers.equals(other.identifiers)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameter != other.parameter) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String value = null;
        try (CRSWriter writer = new CRSWriter();){
            writer.write(this);
            value = writer.toString();
        }
        return value;
    }
}

