/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.coverage.CoverageData;
import mil.nga.geopackage.extension.coverage.CoverageDataPngImage;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDataType;
import mil.nga.geopackage.extension.coverage.GriddedTile;
import mil.nga.geopackage.tiles.ImageUtils;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.geopackage.tiles.user.TileTableMetadata;
import mil.nga.proj.Projection;

public class CoverageDataPng
extends CoverageData<CoverageDataPngImage> {
    public CoverageDataPng(GeoPackage geoPackage, TileDao tileDao, Integer width, Integer height, Projection requestProjection) {
        super(geoPackage, tileDao, width, height, requestProjection);
    }

    public CoverageDataPng(GeoPackage geoPackage, TileDao tileDao) {
        this(geoPackage, tileDao, null, null, tileDao.getProjection());
    }

    public CoverageDataPng(GeoPackage geoPackage, TileDao tileDao, Projection requestProjection) {
        this(geoPackage, tileDao, null, null, requestProjection);
    }

    @Override
    public CoverageDataPngImage createImage(TileRow tileRow) {
        return new CoverageDataPngImage(tileRow);
    }

    @Override
    public double getValue(GriddedTile griddedTile, TileRow tileRow, int x, int y) {
        BufferedImage image = null;
        try {
            image = tileRow.getTileDataImage();
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed to get the Tile Row Data Image", (Throwable)e);
        }
        double value = this.getValue(griddedTile, image, x, y);
        return value;
    }

    public Double getValue(GriddedTile griddedTile, CoverageDataPngImage image, int x, int y) {
        return this.getValue(griddedTile, image.getRaster(), x, y);
    }

    public short getPixelValue(BufferedImage image, int x, int y) {
        this.validateImageType(image);
        WritableRaster raster = image.getRaster();
        short pixelValue = this.getPixelValue(raster, x, y);
        return pixelValue;
    }

    public int getUnsignedPixelValue(BufferedImage image, int x, int y) {
        short pixelValue = this.getPixelValue(image, x, y);
        int unsignedPixelValue = this.getUnsignedPixelValue(pixelValue);
        return unsignedPixelValue;
    }

    public short getPixelValue(WritableRaster raster, int x, int y) {
        Object pixelData = raster.getDataElements(x, y, null);
        short[] sdata = (short[])pixelData;
        if (sdata.length != 1) {
            throw new UnsupportedOperationException("This method is not supported by this color model");
        }
        short pixelValue = sdata[0];
        return pixelValue;
    }

    public int getUnsignedPixelValue(WritableRaster raster, int x, int y) {
        short pixelValue = this.getPixelValue(raster, x, y);
        int unsignedPixelValue = this.getUnsignedPixelValue(pixelValue);
        return unsignedPixelValue;
    }

    public short[] getPixelValues(BufferedImage image) {
        this.validateImageType(image);
        WritableRaster raster = image.getRaster();
        short[] pixelValues = this.getPixelValues(raster);
        return pixelValues;
    }

    public int[] getUnsignedPixelValues(BufferedImage image) {
        short[] pixelValues = this.getPixelValues(image);
        int[] unsignedPixelValues = this.getUnsignedPixelValues(pixelValues);
        return unsignedPixelValues;
    }

    public short[] getPixelValues(WritableRaster raster) {
        DataBufferUShort buffer = (DataBufferUShort)raster.getDataBuffer();
        short[] pixelValues = buffer.getData();
        return pixelValues;
    }

    public int[] getUnsignedPixelValues(WritableRaster raster) {
        short[] pixelValues = this.getPixelValues(raster);
        int[] unsignedPixelValues = this.getUnsignedPixelValues(pixelValues);
        return unsignedPixelValues;
    }

    public void validateImageType(BufferedImage image) {
        if (image == null) {
            throw new GeoPackageException("The image is null");
        }
        if (image.getColorModel().getTransferType() != 1) {
            throw new GeoPackageException("The coverage data tile is expected to be a 16 bit unsigned short, actual: " + image.getColorModel().getTransferType());
        }
    }

    @Override
    public Double getValue(GriddedTile griddedTile, byte[] imageBytes, int x, int y) {
        BufferedImage image;
        try {
            image = ImageUtils.getImage(imageBytes);
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed to create an image from image bytes", (Throwable)e);
        }
        Double value = this.getValue(griddedTile, image, x, y);
        return value;
    }

    public Double getValue(GriddedTile griddedTile, BufferedImage image, int x, int y) {
        short pixelValue = this.getPixelValue(image, x, y);
        Double value = this.getValue(griddedTile, pixelValue);
        return value;
    }

    public Double getValue(GriddedTile griddedTile, WritableRaster raster, int x, int y) {
        short pixelValue = this.getPixelValue(raster, x, y);
        Double value = this.getValue(griddedTile, pixelValue);
        return value;
    }

    @Override
    public Double[] getValues(GriddedTile griddedTile, byte[] imageBytes) {
        BufferedImage image;
        try {
            image = ImageUtils.getImage(imageBytes);
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed to create an image from image bytes", (Throwable)e);
        }
        Double[] values = this.getValues(griddedTile, image);
        return values;
    }

    public Double[] getValues(GriddedTile griddedTile, BufferedImage image) {
        short[] pixelValues = this.getPixelValues(image);
        Double[] values = this.getValues(griddedTile, pixelValues);
        return values;
    }

    public Double[] getValues(GriddedTile griddedTile, WritableRaster raster) {
        short[] pixelValues = this.getPixelValues(raster);
        Double[] values = this.getValues(griddedTile, pixelValues);
        return values;
    }

    public BufferedImage drawTile(short[] pixelValues, int tileWidth, int tileHeight) {
        BufferedImage image = this.createImage(tileWidth, tileHeight);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                short pixelValue = pixelValues[y * tileWidth + x];
                this.setPixelValue(raster, x, y, pixelValue);
            }
        }
        return image;
    }

    public byte[] drawTileData(short[] pixelValues, int tileWidth, int tileHeight) {
        BufferedImage image = this.drawTile(pixelValues, tileWidth, tileHeight);
        byte[] bytes = this.getImageBytes(image);
        return bytes;
    }

    public BufferedImage drawTile(short[][] pixelValues) {
        int tileWidth = pixelValues[0].length;
        int tileHeight = pixelValues.length;
        BufferedImage image = this.createImage(tileWidth, tileHeight);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                short pixelValue = pixelValues[y][x];
                this.setPixelValue(raster, x, y, pixelValue);
            }
        }
        return image;
    }

    public byte[] drawTileData(short[][] pixelValues) {
        BufferedImage image = this.drawTile(pixelValues);
        byte[] bytes = this.getImageBytes(image);
        return bytes;
    }

    public BufferedImage drawTile(int[] unsignedPixelValues, int tileWidth, int tileHeight) {
        BufferedImage image = this.createImage(tileWidth, tileHeight);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                int unsignedPixelValue = unsignedPixelValues[y * tileWidth + x];
                this.setPixelValue(raster, x, y, unsignedPixelValue);
            }
        }
        return image;
    }

    public byte[] drawTileData(int[] unsignedPixelValues, int tileWidth, int tileHeight) {
        BufferedImage image = this.drawTile(unsignedPixelValues, tileWidth, tileHeight);
        byte[] bytes = this.getImageBytes(image);
        return bytes;
    }

    public BufferedImage drawTile(int[][] unsignedPixelValues) {
        int tileWidth = unsignedPixelValues[0].length;
        int tileHeight = unsignedPixelValues.length;
        BufferedImage image = this.createImage(tileWidth, tileHeight);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                int unsignedPixelValue = unsignedPixelValues[y][x];
                this.setPixelValue(raster, x, y, unsignedPixelValue);
            }
        }
        return image;
    }

    public byte[] drawTileData(int[][] unsignedPixelValues) {
        BufferedImage image = this.drawTile(unsignedPixelValues);
        byte[] bytes = this.getImageBytes(image);
        return bytes;
    }

    public BufferedImage drawTile(GriddedTile griddedTile, Double[] values, int tileWidth, int tileHeight) {
        BufferedImage image = this.createImage(tileWidth, tileHeight);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                Double value = values[y * tileWidth + x];
                short pixelValue = this.getPixelValue(griddedTile, value);
                this.setPixelValue(raster, x, y, pixelValue);
            }
        }
        return image;
    }

    @Override
    public byte[] drawTileData(GriddedTile griddedTile, Double[] values, int tileWidth, int tileHeight) {
        BufferedImage image = this.drawTile(griddedTile, values, tileWidth, tileHeight);
        byte[] bytes = this.getImageBytes(image);
        return bytes;
    }

    public BufferedImage drawTile(GriddedTile griddedTile, Double[][] values) {
        int tileWidth = values[0].length;
        int tileHeight = values.length;
        BufferedImage image = this.createImage(tileWidth, tileHeight);
        WritableRaster raster = image.getRaster();
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                Double value = values[y][x];
                short pixelValue = this.getPixelValue(griddedTile, value);
                this.setPixelValue(raster, x, y, pixelValue);
            }
        }
        return image;
    }

    @Override
    public byte[] drawTileData(GriddedTile griddedTile, Double[][] values) {
        BufferedImage image = this.drawTile(griddedTile, values);
        byte[] bytes = this.getImageBytes(image);
        return bytes;
    }

    public BufferedImage createImage(int tileWidth, int tileHeight) {
        return new BufferedImage(tileWidth, tileHeight, 11);
    }

    public byte[] getImageBytes(BufferedImage image) {
        byte[] bytes = null;
        try {
            bytes = ImageUtils.writeImageToBytes(image, "png");
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed to write image to png bytes", (Throwable)e);
        }
        return bytes;
    }

    public void setPixelValue(WritableRaster raster, int x, int y, short pixelValue) {
        short[] data = new short[]{pixelValue};
        raster.setDataElements(x, y, data);
    }

    public void setPixelValue(WritableRaster raster, int x, int y, int unsignedPixelValue) {
        short pixelValue = this.getPixelValue(unsignedPixelValue);
        this.setPixelValue(raster, x, y, pixelValue);
    }

    public static CoverageDataPng createTileTable(GeoPackage geoPackage, TileTableMetadata metadata) {
        return (CoverageDataPng)CoverageData.createTileTable(geoPackage, metadata, GriddedCoverageDataType.INTEGER);
    }
}

