/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.baremaps.iploc.data.Ipv4;
import org.apache.baremaps.iploc.database.InetnumLocationDao;
import org.apache.baremaps.iploc.dto.InetnumLocationDto;

@Singleton
@Path(value="/")
public class IplocResources {
    private final InetnumLocationDao inetnumLocationDao;

    @Inject
    public IplocResources(InetnumLocationDao inetnumLocationDao) {
        this.inetnumLocationDao = inetnumLocationDao;
    }

    @GET
    @Path(value="/api/ip/{ip}")
    public Response getIpToLocation(@PathParam(value="ip") String ip) {
        try {
            Ipv4 ipv4 = new Ipv4(ip);
            List inetnumLocations = this.inetnumLocationDao.findByIp(ipv4.getIp());
            List<InetnumLocationDto> inetnumLocationDtos = inetnumLocations.stream().map(InetnumLocationDto::new).toList();
            return Response.status((int)200).header("Access-Control-Allow-Origin", (Object)"*").header("Content-Type", (Object)"application/json").entity(inetnumLocationDtos).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{path:.*}")
    public Response get(@PathParam(value="path") String path) {
        Response response;
        block9: {
            if (((String)path).equals("") || ((String)path).endsWith("/")) {
                path = (String)path + "index.html";
            }
            path = String.format("iploc/%s", path);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream((String)path);
            try {
                byte[] bytes = inputStream.readAllBytes();
                response = Response.ok().entity((Object)bytes).build();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Response.status((int)404).build();
                }
            }
            inputStream.close();
        }
        return response;
    }
}

